/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.controller;

import cn.langpy.kotime.annotation.Auth;
import cn.langpy.kotime.config.DefaultConfig;
import cn.langpy.kotime.model.CpuInfo;
import cn.langpy.kotime.model.ExceptionInfo;
import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.HeapMemoryInfo;
import cn.langpy.kotime.model.MethodInfo;
import cn.langpy.kotime.model.ParamMetric;
import cn.langpy.kotime.model.PhysicalMemoryInfo;
import cn.langpy.kotime.model.SystemStatistic;
import cn.langpy.kotime.model.TextParam;
import cn.langpy.kotime.model.ThreadInfo;
import cn.langpy.kotime.service.ClassService;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.service.SysUsageService;
import cn.langpy.kotime.service.ThreadUsageService;
import cn.langpy.kotime.util.Context;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/koTime"})
public class KoTimeController {
    private static Logger log = Logger.getLogger(KoTimeController.class.toString());

    @GetMapping(value={"/getConfig"})
    @ResponseBody
    @Auth
    public DefaultConfig getConfig() {
        DefaultConfig config = Context.getConfig();
        return config;
    }

    @GetMapping(value={"/getStatistic"})
    @ResponseBody
    @Auth
    public SystemStatistic getStatistic() {
        GraphService graphService = GraphService.getInstance();
        SystemStatistic system = graphService.getRunStatistic();
        return system;
    }

    @GetMapping(value={"/getApis"})
    @ResponseBody
    @Auth
    public List<MethodInfo> getApis(String question) {
        GraphService graphService = GraphService.getInstance();
        List<MethodInfo> list = null;
        list = StringUtils.hasText((String)question) ? graphService.searchMethods(question) : graphService.getControllers();
        Collections.sort(list);
        return list;
    }

    @GetMapping(value={"/getParamGraph"})
    @ResponseBody
    @Auth
    public Map<String, ParamMetric> getParamGraph(String methodId) {
        GraphService graphService = GraphService.getInstance();
        Map<String, ParamMetric> list = graphService.getMethodParamGraph(methodId);
        return list;
    }

    @GetMapping(value={"/getApiTips"})
    @ResponseBody
    @Auth
    public List<String> getApiTips(String question) {
        GraphService graphService = GraphService.getInstance();
        List<String> list = graphService.getCondidates(question);
        return list;
    }

    @GetMapping(value={"/getExceptions"})
    @ResponseBody
    @Auth
    public List<ExceptionNode> getExceptions() {
        GraphService graphService = GraphService.getInstance();
        List<ExceptionNode> exceptionList = graphService.getExceptions();
        return exceptionList;
    }

    @GetMapping(value={"/getTree"})
    @ResponseBody
    @Auth
    public MethodInfo getTree(String methodName) {
        GraphService graphService = GraphService.getInstance();
        MethodInfo tree = graphService.getTree(methodName);
        return tree;
    }

    @GetMapping(value={"/getMethodsByExceptionId"})
    @ResponseBody
    @Auth
    public List<ExceptionInfo> getMethodsByExceptionId(String exceptionId, String message) {
        GraphService graphService = GraphService.getInstance();
        List<ExceptionInfo> exceptionInfos = graphService.getExceptionInfos(exceptionId, message);
        return exceptionInfos;
    }

    @PostMapping(value={"/updateConfig"})
    @ResponseBody
    @Auth
    public boolean updateConfig(@RequestBody DefaultConfig config) {
        DefaultConfig koTimeConfig = Context.getConfig();
        if (config.getEnable() != null) {
            koTimeConfig.setEnable(config.getEnable());
        }
        if (config.getExceptionEnable() != null) {
            koTimeConfig.setExceptionEnable(config.getExceptionEnable());
        }
        if (config.getLogEnable() != null) {
            koTimeConfig.setLogEnable(config.getLogEnable());
        }
        if (config.getMailEnable() != null) {
            koTimeConfig.setMailEnable(config.getMailEnable());
        }
        if (config.getAbbreviationEnable() != null) {
            koTimeConfig.setAbbreviationEnable(config.getAbbreviationEnable());
        }
        if (config.getThreshold() != null) {
            koTimeConfig.setThreshold(config.getThreshold());
        }
        if (config.getLanguage() != null) {
            koTimeConfig.setLanguage(config.getLanguage());
        }
        return true;
    }

    @PostMapping(value={"/updateClass"})
    @ResponseBody
    @Auth
    public Map updateClass(@RequestParam(value="classFile") MultipartFile classFile, String className) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (classFile == null || classFile.isEmpty()) {
            map.put("state", 0);
            map.put("message", "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            return map;
        }
        if (!StringUtils.hasText((String)className)) {
            map.put("state", 0);
            map.put("message", "\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return map;
        }
        className = className.trim();
        File file = null;
        try {
            String originalFilename = classFile.getOriginalFilename();
            if (!originalFilename.endsWith(".class")) {
                map.put("state", 0);
                map.put("message", "\u4ec5\u652f\u6301.class\u6587\u4ef6");
                return map;
            }
            String[] filename = originalFilename.split("\\.");
            String substring = className.substring(className.lastIndexOf(".") + 1);
            if (!substring.equals(filename[0])) {
                map.put("state", 0);
                map.put("message", "\u8bf7\u786e\u8ba4\u7c7b\u540d\u662f\u5426\u6b63\u786e");
                return map;
            }
            file = KoTimeController.uploadFile(classFile.getBytes(), filename[0]);
        }
        catch (IOException e) {
            log.severe("Error class file!");
            map.put("state", 0);
            map.put("message", "\u65e0\u6cd5\u89e3\u6790\u6587\u4ef6");
            return map;
        }
        ClassService classService = ClassService.getInstance();
        classService.updateClass(className, file.getAbsolutePath());
        file.deleteOnExit();
        map.put("state", 1);
        map.put("message", "\u66f4\u65b0\u6210\u529f");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File uploadFile(byte[] file, String fileName) throws IOException {
        OutputStream out = null;
        try {
            File targetFile = File.createTempFile(fileName, ".class", new File(System.getProperty("java.io.tmpdir")));
            out = new FileOutputStream(targetFile.getAbsolutePath());
            ((FileOutputStream)out).write(file);
            out.flush();
            File file2 = targetFile;
            return file2;
        }
        catch (Exception e) {
            log.severe("" + e);
        }
        finally {
            if (out != null) {
                out.flush();
                ((FileOutputStream)out).close();
            }
        }
        return null;
    }

    @GetMapping(value={"/getCpuInfo"})
    @ResponseBody
    @Auth
    public CpuInfo getCpuInfo() {
        SysUsageService usageService = SysUsageService.newInstance();
        CpuInfo cpuInfo = usageService.getCpuInfo();
        return cpuInfo;
    }

    @GetMapping(value={"/getHeapMemoryInfo"})
    @ResponseBody
    @Auth
    public HeapMemoryInfo getHeapMemoryInfo() {
        SysUsageService usageService = SysUsageService.newInstance();
        HeapMemoryInfo heapMemoryInfo = usageService.getHeapMemoryInfo();
        return heapMemoryInfo;
    }

    @GetMapping(value={"/getPhysicalMemoryInfo"})
    @ResponseBody
    @Auth
    public PhysicalMemoryInfo getPhysicalMemoryInfo() {
        SysUsageService usageService = SysUsageService.newInstance();
        PhysicalMemoryInfo physicalMemoryInfo = usageService.getPhysicalMemoryInfo();
        return physicalMemoryInfo;
    }

    @PostMapping(value={"/clearData"})
    @ResponseBody
    @Auth
    public boolean clearData() {
        GraphService graphService = GraphService.getInstance();
        graphService.clearAll();
        return true;
    }

    @GetMapping(value={"/getThreadsInfo"})
    @ResponseBody
    @Auth
    public Map getThreadsInfo(String state) {
        ThreadUsageService usageService = ThreadUsageService.newInstance();
        List<ThreadInfo> threads = usageService.getThreads();
        threads = threads.stream().sorted(ThreadInfo.COMPARATOR).collect(Collectors.toList());
        Map<String, Long> stateCounting = threads.stream().collect(Collectors.groupingBy(ThreadInfo::getState, Collectors.counting()));
        stateCounting.put("all", Long.valueOf(threads.size()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statistics", stateCounting);
        if (StringUtils.hasText((String)state)) {
            threads = threads.stream().filter(a -> a.getState().equals(state)).collect(Collectors.toList());
        }
        map.put("threads", threads);
        return map;
    }

    @PostMapping(value={"/updateDynamicProperties"})
    @ResponseBody
    @Auth
    public boolean updateDynamicProperties(@RequestBody TextParam textParam) {
        if (!StringUtils.hasText((String)textParam.getText())) {
            return false;
        }
        String[] textSplit = textParam.getText().trim().split("\n");
        Properties dynamicProperties = Context.getDynamicProperties();
        for (String line : textSplit) {
            int i;
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//") || (i = line.indexOf("=")) < 1) continue;
            String propertyStr = line.substring(0, i).trim();
            String valueStr = line.substring(i + 1).trim();
            log.info("updated property: " + propertyStr + "=(" + dynamicProperties.get(propertyStr) + "->" + valueStr + ")");
            dynamicProperties.setProperty(propertyStr, valueStr);
        }
        return true;
    }

    @GetMapping(value={"/getDynamicProperties"})
    @ResponseBody
    @Auth
    public Map getDynamicProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state", 0);
        map.put("message", "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Properties dynamicProperties = Context.getDynamicProperties();
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : dynamicProperties.stringPropertyNames()) {
            String value = dynamicProperties.getProperty(key);
            if (value == null) continue;
            stringBuilder.append(key + "=" + value + "\n");
        }
        map.put("data", stringBuilder.toString());
        return map;
    }
}

