/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.service;

import cn.langpy.kotime.model.MethodNode;
import cn.langpy.kotime.util.Context;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.StringUtils;

public class EmailSendService {
    private static Logger log = Logger.getLogger(EmailSendService.class.toString());
    private static volatile JavaMailSenderImpl javaMailSender;
    private static ConcurrentMap<String, Integer> redMethods;
    private static final ExecutorService emailExecutors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JavaMailSender getMailSender() {
        if (javaMailSender != null) return javaMailSender;
        Class<EmailSendService> clazz = EmailSendService.class;
        synchronized (EmailSendService.class) {
            if (javaMailSender != null) return javaMailSender;
            javaMailSender = new JavaMailSenderImpl();
            javaMailSender.setHost(Context.getConfig().getMailHost());
            javaMailSender.setPort(Context.getConfig().getMailPort().intValue());
            javaMailSender.setUsername(Context.getConfig().getMailUser());
            javaMailSender.setPassword(Context.getConfig().getMailCode());
            javaMailSender.setProtocol(Context.getConfig().getMailProtocol());
            javaMailSender.setDefaultEncoding(Context.getConfig().getMailEncoding());
            // ** MonitorExit[var0] (shouldn't be in output)
            return javaMailSender;
        }
    }

    public static void sendNoticeAsync(MethodNode current) {
        emailExecutors.submit(() -> EmailSendService.sendNotice(current));
    }

    public static void sendNotice(MethodNode current) {
        if (!StringUtils.hasText((String)Context.getConfig().getMailReceivers())) {
            return;
        }
        JavaMailSender mailSender = EmailSendService.getMailSender();
        if (redMethods.containsKey(current.getId())) {
            int n = (Integer)redMethods.get(current.getId());
            if (++n >= Context.getConfig().getMailThreshold()) {
                mailSender.send(EmailSendService.createMessage(mailSender, current));
                redMethods.put(current.getId(), -2000);
            } else {
                redMethods.put(current.getId(), n);
            }
        } else {
            redMethods.put(current.getId(), 1);
            if (Context.getConfig().getMailThreshold() == 1) {
                mailSender.send(EmailSendService.createMessage(mailSender, current));
            }
        }
    }

    private static MimeMessage createMessage(JavaMailSender mailSender, MethodNode current) {
        MimeMessage mimeMessage = null;
        try {
            mimeMessage = mailSender.createMimeMessage();
            EmailSendService.configMessage(current, mimeMessage);
        }
        catch (MessagingException e) {
            log.severe("Error email message!");
        }
        return mimeMessage;
    }

    private static void configMessage(MethodNode current, MimeMessage mimeMessage) throws MessagingException {
        String[] receiversArray = Context.getConfig().getMailReceivers().split(",");
        MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true);
        messageHelper.setSubject("KoTime\u8017\u65f6\u9884\u8b66-" + Context.getConfig().getDataPrefix() + "-" + current.getName());
        messageHelper.setFrom(Context.getConfig().getMailUser());
        messageHelper.setTo(receiversArray);
        messageHelper.setSentDate(new Date());
        messageHelper.setText(EmailSendService.createNoticeTemplate(current), true);
    }

    private static String createNoticeTemplate(MethodNode current) {
        return "<h4>\u60a8\u6709\u4e00\u4e2a\u65b9\u6cd5\u8017\u65f6\u6709" + Context.getConfig().getMailThreshold() + "\u6b21\u8d85\u8fc7\u4e86\u9608\u503c\uff08" + Context.getConfig().getThreshold() + "ms\uff09\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a</h4>\n<div style=\"background-color: #fafdfd;border-radius: 5px;width: 600px;padding: 10px;box-shadow: #75f1bf 2px 2px 2px 2px\">\n    <div>\u9879\u76ee\uff1a" + Context.getConfig().getDataPrefix() + "</div>\n    <div>\u7c7b\u540d\uff1a" + current.getClassName() + "</div>\n    <div>\u65b9\u6cd5\uff1a" + current.getMethodName() + "</div>\n    <div>\u6700\u8fd1\u8017\u65f6\uff1a" + current.getValue() + " ms</div>\n</div>\n<p>\u8bf7\u524d\u5f80\u7cfb\u7edf\u67e5\u770b</p>\n<p>" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")) + "</p>";
    }

    static {
        redMethods = new ConcurrentHashMap<String, Integer>();
        emailExecutors = Executors.newFixedThreadPool(5);
    }
}

