/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.controller;

import cn.langpy.kotime.annotation.Auth;
import cn.langpy.kotime.model.JvmMemoryInfo;
import cn.langpy.kotime.model.KoResult;
import cn.langpy.kotime.model.PhysicalMemoryInfo;
import cn.langpy.kotime.service.core.SystemService;
import cn.langpy.kotime.service.metric.MemoryMetricService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/koTime/memories"})
public class KoMemoryController {
    private static Logger log = Logger.getLogger(KoMemoryController.class.toString());

    @GetMapping(value={"/heap"})
    @ResponseBody
    @Auth
    public KoResult heap() {
        MemoryMetricService instance = (MemoryMetricService)SystemService.getInstance(MemoryMetricService.class);
        JvmMemoryInfo heapMemoryInfo = instance.getHeapMemoryInfo();
        return KoResult.success(heapMemoryInfo);
    }

    @GetMapping(value={"/nonHeap"})
    @ResponseBody
    @Auth
    public KoResult nonHeap() {
        MemoryMetricService instance = (MemoryMetricService)SystemService.getInstance(MemoryMetricService.class);
        JvmMemoryInfo heapMemoryInfo = instance.getNonHeapMemoryInfo();
        return KoResult.success(heapMemoryInfo);
    }

    @GetMapping(value={"/physical"})
    @ResponseBody
    @Auth
    public KoResult physical() {
        MemoryMetricService instance = (MemoryMetricService)SystemService.getInstance(MemoryMetricService.class);
        PhysicalMemoryInfo heapMemoryInfo = instance.getPhysicalMemoryInfo();
        return KoResult.success(heapMemoryInfo);
    }

    @GetMapping(value={"/heap/export"})
    @ResponseBody
    @Auth
    public void heapExport(Boolean live, HttpServletResponse response) {
        live = live == null ? false : live;
        MemoryMetricService instance = (MemoryMetricService)SystemService.getInstance(MemoryMetricService.class);
        String heapDumpFile = instance.getHeapDumpFile(live);
        if (heapDumpFile == null) {
            throw new RuntimeException("Can not dumpheap file!");
        }
        log.info(heapDumpFile);
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/octet-stream");
        response.addHeader("Content-Disposition", "attachment; filename=" + instance.getHeapDumpFileName(live));
        try (ServletOutputStream out = response.getOutputStream();
             BufferedOutputStream bufferedOut = new BufferedOutputStream((OutputStream)out);
             FileInputStream fileInputStream = new FileInputStream(heapDumpFile);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = bufferedInputStream.read(buffer)) != -1) {
                bufferedOut.write(buffer, 0, bytesRead);
            }
            bufferedOut.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

