/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.controller;

import cn.langpy.kotime.annotation.Auth;
import cn.langpy.kotime.model.KoResult;
import cn.langpy.kotime.model.TextParam;
import cn.langpy.kotime.util.Context;
import java.util.Properties;
import java.util.logging.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/koTime/dynamicProperties"})
public class KoDynamicPropertyController {
    private static Logger log = Logger.getLogger(KoDynamicPropertyController.class.toString());

    @PutMapping
    @ResponseBody
    @Auth
    public KoResult updateDynamicProperties(@RequestBody TextParam textParam) {
        if (!StringUtils.hasText((String)textParam.getText())) {
            return KoResult.failed("\u66f4\u65b0\u5931\u8d25");
        }
        String[] textSplit = textParam.getText().trim().split("\n");
        Properties dynamicProperties = Context.getDynamicProperties();
        for (String line : textSplit) {
            int i;
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//") || (i = line.indexOf("=")) < 1) continue;
            String propertyStr = line.substring(0, i).trim();
            String valueStr = line.substring(i + 1).trim();
            log.info("updated property: " + propertyStr + "=(" + dynamicProperties.get(propertyStr) + "->" + valueStr + ")");
            dynamicProperties.setProperty(propertyStr, valueStr);
        }
        return KoResult.success();
    }

    @GetMapping
    @ResponseBody
    @Auth
    public KoResult getDynamicProperties() {
        Properties dynamicProperties = Context.getDynamicProperties();
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : dynamicProperties.stringPropertyNames()) {
            String value = dynamicProperties.getProperty(key);
            if (value == null) continue;
            stringBuilder.append(key + "=" + value + "\n");
        }
        return KoResult.success(stringBuilder.toString());
    }
}

