/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.service.core;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public class SystemService {
    Logger log = Logger.getLogger(SystemService.class.toString());
    private static final String HotSpotDiagnosticName = "com.sun.management:type=HotSpotDiagnostic";
    static final Map<String, SystemService> serviceMap = new ConcurrentHashMap<String, SystemService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends SystemService> T getInstance(Class<? extends SystemService> clazz) {
        String simpleName = clazz.getSimpleName();
        SystemService systemService = serviceMap.get(simpleName);
        if (systemService != null) return (T)systemService;
        Class<SystemService> clazz2 = SystemService.class;
        synchronized (SystemService.class) {
            if (!serviceMap.containsKey(simpleName)) {
                try {
                    systemService = clazz.newInstance();
                    serviceMap.put(simpleName, systemService);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                systemService = serviceMap.get(simpleName);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (T)systemService;
        }
    }

    protected MemoryUsage getHeapMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
    }

    protected MemoryUsage getNonHeapMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
    }

    protected List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementFactory.getGarbageCollectorMXBeans();
    }

    protected List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementFactory.getMemoryPoolMXBeans();
    }

    protected ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }

    protected ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementFactory.getClassLoadingMXBean();
    }

    public HotSpotDiagnosticMXBean getHotSpotDiagnosticMXBean() {
        HotSpotDiagnosticMXBean hotSpotDiagnostic = null;
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            hotSpotDiagnostic = ManagementFactory.newPlatformMXBeanProxy(server, HotSpotDiagnosticName, HotSpotDiagnosticMXBean.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return hotSpotDiagnostic;
    }
}

