/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.controller;

import cn.langpy.kotime.annotation.Auth;
import cn.langpy.kotime.model.KoResult;
import cn.langpy.kotime.model.MethodInfo;
import cn.langpy.kotime.model.ParamMetric;
import cn.langpy.kotime.model.SystemStatistic;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.util.Context;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/koTime/interfaces"})
public class KoInterfaceController {
    private static Logger log = Logger.getLogger(KoInterfaceController.class.toString());

    @GetMapping(value={"/usage"})
    @ResponseBody
    @Auth
    public KoResult usage() {
        GraphService graphService = GraphService.getInstance();
        SystemStatistic system = graphService.getRunStatistic();
        return KoResult.success(system);
    }

    @GetMapping
    @ResponseBody
    @Auth
    public KoResult<List<MethodInfo>> getInterfaces(String question, String orderBy, String sort) {
        GraphService graphService = GraphService.getInstance();
        List<MethodInfo> list = null;
        list = StringUtils.hasText((String)question) ? graphService.searchMethods(question) : graphService.getControllers();
        Collections.sort(list, (o1, o2) -> {
            int sortValue = -1;
            if ("asc".equals(sort)) {
                sortValue = 1;
            }
            if ("callNum".equals(orderBy)) {
                return o1.getCallNum().compareTo(o2.getCallNum()) * sortValue;
            }
            return o1.getAvgRunTime().compareTo(o2.getAvgRunTime()) * sortValue;
        });
        return KoResult.success(list);
    }

    @GetMapping(value={"/export"})
    @ResponseBody
    @Auth
    public void export(String question, String orderBy, String sort, HttpServletResponse response) {
        List<MethodInfo> apis = this.getInterfaces(question, orderBy, sort).getContent();
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment; filename=interfaces.csv");
        try (ServletOutputStream out = response.getOutputStream();
             BufferedOutputStream bufferedOut = new BufferedOutputStream((OutputStream)out);){
            String line = "\u5e8f\u53f7,\u7c7b\u540d,\u65b9\u6cd5\u540d,\u8def\u7531,\u5e73\u5747\u54cd\u5e94\uff08ms\uff09,\u8c03\u7528\u6b21\u6570\n";
            if ("english".equals(Context.getConfig().getLanguage())) {
                line = "No,ClassName,Method,Route,Avg(ms),CallNum\n";
            }
            bufferedOut.write(line.getBytes("utf-8"));
            for (int i = 0; i < apis.size(); ++i) {
                MethodInfo methodInfo = apis.get(i);
                line = i + 1 + "," + methodInfo.getClassName() + "," + methodInfo.getMethodName() + "()," + methodInfo.getRouteName() + "," + methodInfo.getAvgRunTime() + "," + methodInfo.getCallNum() + "\n";
                bufferedOut.write(line.getBytes("utf-8"));
            }
            bufferedOut.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/searchCondidate"})
    @ResponseBody
    @Auth
    public KoResult<List<String>> searchCondidate(String question) {
        GraphService graphService = GraphService.getInstance();
        List<String> list = graphService.getCondidates(question);
        return KoResult.success(list);
    }

    @GetMapping(value={"/{methodId}/paramMetric"})
    @ResponseBody
    @Auth
    public KoResult<Map<String, ParamMetric>> paramMetric(@PathVariable(value="methodId") String methodId) {
        GraphService graphService = GraphService.getInstance();
        Map<String, ParamMetric> list = graphService.getMethodParamGraph(methodId);
        return KoResult.success(list);
    }

    @GetMapping(value={"/{methodId}/tree"})
    @ResponseBody
    @Auth
    public KoResult getTree(@PathVariable(value="methodId") String methodId) {
        GraphService graphService = GraphService.getInstance();
        MethodInfo tree = graphService.getTree(methodId);
        return KoResult.success(tree);
    }
}

