/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.service.metric;

import cn.langpy.kotime.model.JvmMemoryInfo;
import cn.langpy.kotime.model.PhysicalMemoryInfo;
import cn.langpy.kotime.service.core.SystemService;
import cn.langpy.kotime.util.Context;
import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class MemoryMetricService
extends SystemService {
    Logger log = Logger.getLogger(MemoryMetricService.class.toString());
    private static final String STANDARD_DUMP_NAME = "kotime-heapdump-%s.hprof";

    public JvmMemoryInfo getHeapMemoryInfo() {
        MemoryUsage memoryUsage = this.getHeapMemoryUsage();
        long initTotalMemorySize = memoryUsage.getInit();
        long maxMemorySize = memoryUsage.getMax();
        long usedMemorySize = memoryUsage.getUsed();
        JvmMemoryInfo heapMemoryInfo = new JvmMemoryInfo();
        heapMemoryInfo.setInitValue(initTotalMemorySize);
        heapMemoryInfo.setMaxValue(maxMemorySize);
        heapMemoryInfo.setUsedValue(usedMemorySize);
        heapMemoryInfo.setUsedRate((double)usedMemorySize * 1.0 / (double)maxMemorySize);
        return heapMemoryInfo;
    }

    public JvmMemoryInfo getNonHeapMemoryInfo() {
        MemoryUsage memoryUsage = this.getNonHeapMemoryUsage();
        long initTotalMemorySize = memoryUsage.getInit();
        long maxMemorySize = memoryUsage.getMax();
        long usedMemorySize = memoryUsage.getUsed();
        JvmMemoryInfo heapMemoryInfo = new JvmMemoryInfo();
        heapMemoryInfo.setInitValue(initTotalMemorySize);
        heapMemoryInfo.setMaxValue(maxMemorySize);
        heapMemoryInfo.setUsedValue(usedMemorySize);
        heapMemoryInfo.setUsedRate((double)usedMemorySize * 1.0 / (double)maxMemorySize);
        return heapMemoryInfo;
    }

    public PhysicalMemoryInfo getPhysicalMemoryInfo() {
        Map<String, String> processInfo;
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        PhysicalMemoryInfo physicalMemoryInfo = new PhysicalMemoryInfo();
        physicalMemoryInfo.setInitValue(osmxb.getTotalPhysicalMemorySize());
        physicalMemoryInfo.setUsedValue(osmxb.getTotalPhysicalMemorySize() - osmxb.getFreePhysicalMemorySize());
        physicalMemoryInfo.setFreeValue(osmxb.getFreePhysicalMemorySize());
        physicalMemoryInfo.setUsedValue(physicalMemoryInfo.getInitValue() - physicalMemoryInfo.getFreeValue());
        physicalMemoryInfo.setUsedRate((double)physicalMemoryInfo.getUsedValue().longValue() * 1.0 / (double)physicalMemoryInfo.getInitValue().longValue());
        if (this.isLinux() && (processInfo = this.getProcessInfo()).containsKey("VmSize")) {
            String VmRSSStr = processInfo.get("VmRSS");
            String VmSizeStr = VmRSSStr.split(" ")[0].trim();
            long VmRSS = Long.valueOf(VmSizeStr);
            physicalMemoryInfo.setThisUsedValue(VmRSS * 1024L);
            double rate = (double)physicalMemoryInfo.getThisUsedValue().longValue() * 1.0 / (double)physicalMemoryInfo.getInitValue().longValue();
            physicalMemoryInfo.setThisUsedRate(rate);
        }
        return physicalMemoryInfo;
    }

    public boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public Map<String, String> getProcessInfo() {
        HashMap<String, String> processMetrics = new HashMap<String, String>();
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec("cat /proc/" + Context.getPid() + "/status");
        }
        catch (IOException e) {
            this.log.severe("Can not execute 'cat /proc/" + Context.getPid() + "/status'");
            return processMetrics;
        }
        try (InputStream inputStream = process.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                String[] split = line.split(":");
                if (split.length != 2) continue;
                String key = split[0].trim();
                String value = split[1].trim();
                processMetrics.put(key, value);
            }
        }
        catch (Exception e) {
            this.log.severe("Can not read the result of 'cat /proc/" + Context.getPid() + "/status'");
        }
        return processMetrics;
    }

    public String getHeapDumpFile(boolean live) {
        String targetFile = System.getProperty("java.io.tmpdir") + File.separator + this.getHeapDumpFileName(live);
        try {
            HotSpotDiagnosticMXBean hotSpotDiagnostic = this.getHotSpotDiagnosticMXBean();
            if (Files.exists(Paths.get(targetFile, new String[0]), new LinkOption[0])) {
                new File(targetFile).delete();
            }
            hotSpotDiagnostic.dumpHeap(targetFile, live);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.severe("Can not dump heap file!");
        }
        return targetFile;
    }

    public String getHeapDumpFileName(boolean live) {
        if (live) {
            return String.format(STANDARD_DUMP_NAME, "live");
        }
        return String.format(STANDARD_DUMP_NAME, "all");
    }
}

