/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.controller;

import cn.langpy.kotime.annotation.Auth;
import cn.langpy.kotime.model.KoResult;
import cn.langpy.kotime.service.core.SystemService;
import cn.langpy.kotime.service.metric.ClassInfoService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/koTime/classes"})
public class KoClassController {
    private static Logger log = Logger.getLogger(KoClassController.class.toString());

    @GetMapping(value={"/usage"})
    @ResponseBody
    @Auth
    public KoResult usage() {
        ClassInfoService instance = (ClassInfoService)SystemService.getInstance(ClassInfoService.class);
        return KoResult.success(instance.getClassUsage());
    }

    @PutMapping(value={"/{className}/replace"})
    @ResponseBody
    @Auth
    public KoResult updateClass(@RequestParam(value="classFile") MultipartFile classFile, @PathVariable(value="className") String className) {
        if (classFile == null || classFile.isEmpty()) {
            return KoResult.failed("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)className)) {
            return KoResult.failed("\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        className = className.trim();
        File file = null;
        try {
            String originalFilename = classFile.getOriginalFilename();
            if (!originalFilename.endsWith(".class")) {
                return KoResult.failed("\u4ec5\u652f\u6301.class\u6587\u4ef6");
            }
            String[] filename = originalFilename.split("\\.");
            String substring = className.substring(className.lastIndexOf(".") + 1);
            if (!substring.equals(filename[0])) {
                return KoResult.failed("\u8bf7\u786e\u8ba4\u7c7b\u540d\u662f\u5426\u6b63\u786e");
            }
            file = KoClassController.uploadFile(classFile.getBytes(), filename[0]);
        }
        catch (IOException e) {
            log.severe("Error class file!");
            return KoResult.failed("\u65e0\u6cd5\u89e3\u6790\u6587\u4ef6");
        }
        ClassInfoService classService = (ClassInfoService)SystemService.getInstance(ClassInfoService.class);
        classService.updateClass(className, file.getAbsolutePath());
        file.deleteOnExit();
        return KoResult.success("\u66f4\u65b0\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File uploadFile(byte[] file, String fileName) throws IOException {
        OutputStream out = null;
        try {
            File targetFile = File.createTempFile(fileName, ".class", new File(System.getProperty("java.io.tmpdir")));
            out = new FileOutputStream(targetFile.getAbsolutePath());
            ((FileOutputStream)out).write(file);
            out.flush();
            File file2 = targetFile;
            return file2;
        }
        catch (Exception e) {
            log.severe("" + e);
        }
        finally {
            if (out != null) {
                out.flush();
                ((FileOutputStream)out).close();
            }
        }
        return null;
    }
}

