/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.handler;

import cn.langpy.kotime.util.Common;
import java.util.logging.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ComputeTimeHandler {
    private static Logger log = Logger.getLogger(ComputeTimeHandler.class.toString());

    @Pointcut(value="@annotation(cn.langpy.kotime.annotation.ComputeTime)")
    public void preProcess() {
    }

    @Around(value="preProcess()")
    public Object doAroundCompute(ProceedingJoinPoint pjp) throws Throwable {
        long begin = System.nanoTime();
        Object obj = pjp.proceed();
        long end = System.nanoTime();
        Common.showLog(pjp.getTarget().getClass().getName() + "." + pjp.getSignature().getName(), (end - begin) / 1000000L);
        return obj;
    }
}

