/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;

final class JSONWriterPretty
extends JSONWriter {
    final JSONWriter jsonWriter;
    int indent;
    int startObjectOff;

    protected JSONWriterPretty(JSONWriter jsonWriter) {
        super(jsonWriter.context, jsonWriter.charset);
        this.jsonWriter = jsonWriter;
    }

    @Override
    public void writeComma() {
        this.write0(',');
        this.write0('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.write0('\t');
        }
    }

    @Override
    public void writeInt32(int value) {
        this.jsonWriter.writeInt32(value);
    }

    @Override
    public void writeInt64(long i) {
        this.jsonWriter.writeInt64(i);
    }

    @Override
    public void writeFloat(float value) {
        this.jsonWriter.writeFloat(value);
    }

    @Override
    public void writeDouble(double value) {
        this.jsonWriter.writeDouble(value);
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        this.jsonWriter.writeDecimal(value);
    }

    @Override
    public void writeBigInt(BigInteger value, long features) {
        this.jsonWriter.writeBigInt(value, features);
    }

    @Override
    public void writeUUID(UUID value) {
        this.jsonWriter.writeUUID(value);
    }

    @Override
    public void writeString(String str) {
        this.jsonWriter.writeString(str);
    }

    @Override
    public void writeLocalDate(LocalDate date) {
        this.jsonWriter.writeLocalDate(date);
    }

    @Override
    public void writeLocalDateTime(LocalDateTime dateTime) {
        this.jsonWriter.writeLocalDateTime(dateTime);
    }

    @Override
    public void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.jsonWriter.writeDateTime19(year, month, dayOfMonth, hour, minute, second);
    }

    @Override
    public void writeDateTimeISO8601(int year, int month, int dayOfMonth, int hour, int minute, int second, int millis, int offsetSeconds) {
        this.jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, millis, offsetSeconds);
    }

    @Override
    public void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        this.jsonWriter.writeDateYYYMMDD10(year, month, dayOfMonth);
    }

    @Override
    public void writeTimeHHMMSS8(int hour, int minute, int second) {
        this.jsonWriter.writeTimeHHMMSS8(hour, minute, second);
    }

    @Override
    public void writeReference(String path) {
        this.jsonWriter.writeReference(path);
    }

    @Override
    public void startObject() {
        ++this.level;
        this.jsonWriter.startObject = true;
        this.write0('{');
        ++this.indent;
        this.write0('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.write0('\t');
        }
        this.startObjectOff = this.jsonWriter.off;
    }

    @Override
    public void endObject() {
        --this.level;
        --this.indent;
        this.write0('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.write0('\t');
        }
        this.write0('}');
        this.jsonWriter.startObject = false;
    }

    @Override
    public void startArray() {
        ++this.level;
        this.write0('[');
        ++this.indent;
        this.write0('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.write0('\t');
        }
    }

    @Override
    public void endArray() {
        ++this.level;
        --this.indent;
        this.write0('\n');
        for (int i = 0; i < this.indent; ++i) {
            this.write0('\t');
        }
        this.write0(']');
        this.jsonWriter.startObject = false;
    }

    @Override
    public void writeRaw(char[] chars) {
        this.jsonWriter.writeRaw(chars);
    }

    @Override
    public void writeNameRaw(char[] chars) {
        if (this.jsonWriter.startObject) {
            this.jsonWriter.startObject = false;
        } else {
            this.writeComma();
        }
        this.jsonWriter.writeRaw(chars);
    }

    @Override
    public void writeRaw(byte[] bytes) {
        this.jsonWriter.writeRaw(bytes);
    }

    @Override
    public void writeNameRaw(byte[] bytes) {
        if (this.jsonWriter.startObject) {
            this.jsonWriter.startObject = false;
        } else {
            this.writeComma();
        }
        this.jsonWriter.writeRaw(bytes);
    }

    @Override
    public void writeName(String name) {
        if (this.jsonWriter.startObject) {
            this.jsonWriter.startObject = false;
        } else {
            this.writeComma();
        }
        this.jsonWriter.writeString(name);
    }

    @Override
    public void writeNameRaw(byte[] bytes, int offset, int len) {
        this.jsonWriter.writeNameRaw(bytes, offset, len);
    }

    @Override
    public void writeNameRaw(char[] bytes, int offset, int len) {
        this.jsonWriter.writeNameRaw(bytes, offset, len);
    }

    @Override
    protected void write0(char ch) {
        this.jsonWriter.write0(ch);
    }

    @Override
    public void writeRaw(String str) {
        this.jsonWriter.writeRaw(str);
    }

    @Override
    public void writeColon() {
        this.jsonWriter.writeColon();
    }

    @Override
    public void writeInt16(short[] value) {
        this.jsonWriter.writeInt16(value);
    }

    @Override
    public byte[] getBytes() {
        return this.jsonWriter.getBytes();
    }

    @Override
    public void flushTo(Writer to) {
        this.jsonWriter.flushTo(to);
    }

    @Override
    public int flushTo(OutputStream to) throws IOException {
        return this.jsonWriter.flushTo(to);
    }

    @Override
    public int flushTo(OutputStream to, Charset charset) throws IOException {
        return this.jsonWriter.flushTo(to, charset);
    }

    @Override
    public void writeBase64(byte[] bytes) {
        this.jsonWriter.writeBase64(bytes);
    }

    @Override
    public void writeRaw(char ch) {
        this.jsonWriter.writeRaw(ch);
    }

    public String toString() {
        return this.jsonWriter.toString();
    }
}

