/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.logging.Logger;

public class BloomFilter {
    private static Logger log = Logger.getLogger(BloomFilter.class.toString());
    private static final int size = 1000000;
    private static volatile BitSet bits = new BitSet(1000000);
    private static final int[] hashSeeds = new int[]{3, 113, 919, 2203, 4013, 6011};
    private static final List<BiFunction<String, Integer, Integer>> hashFuncs = new ArrayList<BiFunction<String, Integer, Integer>>();

    public static void add(String value) {
        int len = hashFuncs.size();
        for (int i = 0; i < len; ++i) {
            BiFunction<String, Integer, Integer> hashFunc = hashFuncs.get(i);
            int hashSeed = hashSeeds[i];
            Integer bitHash = hashFunc.apply(value, hashSeed);
            bits.set((int)bitHash, true);
        }
    }

    public static boolean exists(String value) {
        int len = hashFuncs.size();
        for (int i = 0; i < len; ++i) {
            int hashSeed;
            BiFunction<String, Integer, Integer> hashFunc = hashFuncs.get(i);
            Integer bitHash = hashFunc.apply(value, hashSeed = hashSeeds[i]);
            boolean isTrue = bits.get(bitHash);
            if (isTrue) continue;
            return false;
        }
        return true;
    }

    private static int hash(String value, int seed) {
        return Math.abs(value.hashCode() * seed + 33) % 1000000;
    }

    static {
        for (int i = 0; i < hashSeeds.length; ++i) {
            hashFuncs.add((v, s) -> BloomFilter.hash(v, s));
        }
    }
}

