/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.service;

import cn.langpy.kotime.annotation.KoListener;
import cn.langpy.kotime.handler.InvokedHandler;
import cn.langpy.kotime.model.MethodNode;
import cn.langpy.kotime.service.EmailSendService;
import cn.langpy.kotime.util.Context;
import java.lang.reflect.Parameter;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;

@KoListener
@Lazy
public class EmailHandler
implements InvokedHandler {
    private static Logger log = Logger.getLogger(EmailHandler.class.toString());
    @Value(value="${ko-time.mail-scope:Controller}")
    private String mailScope;
    @Autowired
    private EmailSendService emailSendService;

    @Override
    public void onInvoked(MethodNode current, MethodNode parent, Parameter[] names, Object[] values) {
        if (current == null || current.getValue() < Context.getConfig().getThreshold()) {
            return;
        }
        if (this.mailScope.equals("All")) {
            this.emailSendService.sendNoticeAsync(current);
        } else if (current.getMethodType().name().equals(this.mailScope)) {
            this.emailSendService.sendNoticeAsync(current);
        }
    }
}

