/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.controller;

import cn.langpy.kotime.annotation.Auth;
import cn.langpy.kotime.config.DefaultConfig;
import cn.langpy.kotime.constant.KoConstant;
import cn.langpy.kotime.model.ExceptionInfo;
import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.MethodInfo;
import cn.langpy.kotime.model.ParamMetric;
import cn.langpy.kotime.model.SystemStatistic;
import cn.langpy.kotime.model.UserInfo;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.util.ClassUtil;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.InvalidAuthInfoException;
import cn.langpy.kotime.util.KoUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/koTime"})
public class KoTimeController {
    @Value(value="${ko-time.user-name:}")
    private String userName;
    @Value(value="${ko-time.password:}")
    private String password;
    @Value(value="${ko-time.agent-path:}")
    private String agentPath;
    private static Logger log = Logger.getLogger(KoTimeController.class.toString());
    private final String uiKitCssText = this.getResourceText("kostatic/uikit.min.css");
    private final String uiKitJsText = this.getResourceText("kostatic/uikit.min.js");
    private final String metricFlowJsText = this.getResourceText("kostatic/Metricflow.js");
    private final String jQueryJsText = this.getResourceText("kostatic/JQuery.min.js");
    private final String uiKitIconsJs = this.getResourceText("kostatic/uikit-icons.js");

    @PostMapping(value={"/login"})
    @ResponseBody
    public Map login(@RequestBody UserInfo userInfo) {
        if (null == userInfo || !StringUtils.hasText((String)userInfo.getUserName()) || !StringUtils.hasText((String)userInfo.getPassword())) {
            throw new InvalidAuthInfoException("failed to login for kotime,please fill userName and password!");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.userName.equals(userInfo.getUserName()) && this.password.equals(userInfo.getPassword())) {
            String token = KoUtil.login(userInfo.getUserName());
            map.put("state", 1);
            map.put("token", token);
            return map;
        }
        map.put("state", 0);
        return map;
    }

    @GetMapping(value={"/isLogin"})
    @ResponseBody
    public Map isLogin(String token) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("state", 1);
        boolean checkLogin = KoUtil.isLogin(token);
        map.put("isLogin", checkLogin ? 1 : 0);
        return map;
    }

    @GetMapping
    public void index(String test, HttpServletResponse response, HttpServletRequest request) {
        if (!Context.getConfig().getEnable().booleanValue()) {
            return;
        }
        if (null != test) {
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        ClassPathResource classPathResource = new ClassPathResource(KoConstant.getViewName());
        try (InputStream inputStream = classPathResource.getInputStream();
             InputStreamReader streamReader = new InputStreamReader(inputStream, "utf-8");
             BufferedReader reader = new BufferedReader(streamReader);
             PrintWriter out = response.getWriter();){
            String context = request.getContextPath();
            if (StringUtils.hasText((String)Context.getConfig().getContextPath())) {
                context = Context.getConfig().getContextPath();
            }
            StringBuilder stringBuilder = new StringBuilder();
            String line = "";
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("globalThresholdValue") > -1) {
                    line = line.replace("globalThresholdValue", Context.getConfig().getThreshold() + "");
                } else if (line.indexOf("globalNeedLoginValue") > -1) {
                    line = line.replace("globalNeedLoginValue", Context.getConfig().getAuthEnable() + "");
                } else if (line.indexOf("contextPath") > -1) {
                    line = line.replace("contextPath", context);
                } else if (line.indexOf("exceptionTitleStyle") > -1) {
                    line = line.replace("exceptionTitleStyle", Context.getConfig().getExceptionEnable() == true ? "" : "display:none;");
                } else if (line.indexOf("UIKitCss") > -1) {
                    line = line.replace("UIKitCss", this.uiKitCssText);
                } else if (line.indexOf("UIKitJs") > -1) {
                    line = line.replace("UIKitJs", this.uiKitJsText);
                } else if (line.indexOf("MetricFlowJs") > -1) {
                    line = line.replace("MetricFlowJs", this.metricFlowJsText);
                } else if (line.indexOf("jQueryJs") > -1) {
                    line = line.replace("jQueryJs", this.jQueryJsText);
                } else if (line.indexOf("uiKitIconsJs") > -1) {
                    line = line.replace("uiKitIconsJs", this.uiKitIconsJs);
                }
                stringBuilder.append(line + "\n");
            }
            line = stringBuilder.toString();
            out.write(line);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    private String getResourceText(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @GetMapping(value={"/getConfig"})
    @ResponseBody
    @Auth
    public DefaultConfig getConfig() {
        DefaultConfig config = Context.getConfig();
        return config;
    }

    @GetMapping(value={"/getStatistic"})
    @ResponseBody
    @Auth
    public SystemStatistic getStatistic() {
        GraphService graphService = GraphService.getInstance();
        SystemStatistic system = graphService.getRunStatistic();
        return system;
    }

    @GetMapping(value={"/getApis"})
    @ResponseBody
    @Auth
    public List<MethodInfo> getApis(String question) {
        GraphService graphService = GraphService.getInstance();
        List<MethodInfo> list = null;
        list = StringUtils.hasText((String)question) ? graphService.searchMethods(question) : graphService.getControllers();
        Collections.sort(list);
        return list;
    }

    @GetMapping(value={"/getParamGraph"})
    @ResponseBody
    @Auth
    public Map<String, ParamMetric> getParamGraph(String methodId) {
        GraphService graphService = GraphService.getInstance();
        Map<String, ParamMetric> list = graphService.getMethodParamGraph(methodId);
        return list;
    }

    @GetMapping(value={"/getApiTips"})
    @ResponseBody
    @Auth
    public List<String> getApiTips(String question) {
        GraphService graphService = GraphService.getInstance();
        List<String> list = graphService.getCondidates(question);
        return list;
    }

    @GetMapping(value={"/getExceptions"})
    @ResponseBody
    @Auth
    public List<ExceptionNode> getExceptions() {
        GraphService graphService = GraphService.getInstance();
        List<ExceptionNode> exceptionList = graphService.getExceptions();
        return exceptionList;
    }

    @GetMapping(value={"/getTree"})
    @ResponseBody
    @Auth
    public MethodInfo getTree(String methodName) {
        GraphService graphService = GraphService.getInstance();
        MethodInfo tree = graphService.getTree(methodName);
        return tree;
    }

    @GetMapping(value={"/getMethodsByExceptionId"})
    @ResponseBody
    @Auth
    public List<ExceptionInfo> getMethodsByExceptionId(String exceptionId, String message) {
        GraphService graphService = GraphService.getInstance();
        List<ExceptionInfo> exceptionInfos = graphService.getExceptionInfos(exceptionId, message);
        return exceptionInfos;
    }

    @PostMapping(value={"/updateConfig"})
    @ResponseBody
    @Auth
    public boolean updateConfig(@RequestBody DefaultConfig config) {
        DefaultConfig koTimeConfig = Context.getConfig();
        if (config.getEnable() != null) {
            koTimeConfig.setEnable(config.getEnable());
        }
        if (config.getExceptionEnable() != null) {
            koTimeConfig.setExceptionEnable(config.getExceptionEnable());
        }
        if (config.getLogEnable() != null) {
            koTimeConfig.setLogEnable(config.getLogEnable());
        }
        if (config.getThreshold() != null) {
            koTimeConfig.setThreshold(config.getThreshold());
        }
        if (config.getLanguage() != null) {
            koTimeConfig.setLanguage(config.getLanguage());
        }
        return true;
    }

    @PostMapping(value={"/updateClass"})
    @ResponseBody
    @Auth
    public Map updateClass(@RequestParam(value="classFile") MultipartFile classFile, String className) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (classFile == null || classFile.isEmpty()) {
            map.put("state", 0);
            map.put("message", "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            return map;
        }
        if (!StringUtils.hasText((String)className)) {
            map.put("state", 0);
            map.put("message", "\u6587\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return map;
        }
        className = className.trim();
        File file = null;
        try {
            String originalFilename = classFile.getOriginalFilename();
            if (!originalFilename.endsWith(".class")) {
                map.put("state", 0);
                map.put("message", "\u4ec5\u652f\u6301.class\u6587\u4ef6");
                return map;
            }
            String[] filename = originalFilename.split("\\.");
            String substring = className.substring(className.lastIndexOf(".") + 1);
            if (!substring.equals(filename[0])) {
                map.put("state", 0);
                map.put("message", "\u8bf7\u786e\u8ba4\u7c7b\u540d\u662f\u5426\u6b63\u786e");
                return map;
            }
            file = KoTimeController.uploadFile(classFile.getBytes(), filename[0]);
        }
        catch (IOException e) {
            log.severe("Error class file!");
            map.put("state", 0);
            map.put("message", "\u65e0\u6cd5\u89e3\u6790\u6587\u4ef6");
            return map;
        }
        File jar = null;
        if (!StringUtils.hasText((String)this.agentPath)) {
            jar = ClassUtil.createJar();
            this.agentPath = jar.getAbsolutePath();
        }
        ClassUtil.updateClass(this.agentPath, className, file.getAbsolutePath());
        file.deleteOnExit();
        if (jar != null) {
            jar.deleteOnExit();
        }
        map.put("state", 1);
        map.put("message", "\u66f4\u65b0\u6210\u529f");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File uploadFile(byte[] file, String fileName) throws IOException {
        OutputStream out = null;
        try {
            File targetFile = File.createTempFile(fileName, ".class", new File(System.getProperty("java.io.tmpdir")));
            out = new FileOutputStream(targetFile.getAbsolutePath());
            ((FileOutputStream)out).write(file);
            out.flush();
            File file2 = targetFile;
            return file2;
        }
        catch (Exception e) {
            log.severe("" + e);
        }
        finally {
            if (out != null) {
                out.flush();
                ((FileOutputStream)out).close();
            }
        }
        return null;
    }
}

