/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.User32;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.driver.wmi.Win32OperatingSystem;
import oshi.software.common.AbstractOSVersionInfoEx;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

@Deprecated
public class WindowsOSVersionInfoEx
extends AbstractOSVersionInfoEx {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOSVersionInfoEx.class);

    public WindowsOSVersionInfoEx() {
        WbemcliUtil.WmiResult<Win32OperatingSystem.OSVersionProperty> versionInfo = new Win32OperatingSystem().queryOsVersion();
        if (versionInfo.getResultCount() < 1) {
            this.handleNoVersionInfo();
        } else {
            int suiteMask = WmiUtil.getUint32(versionInfo, Win32OperatingSystem.OSVersionProperty.SUITEMASK, 0);
            this.setBuildNumber(WmiUtil.getString(versionInfo, Win32OperatingSystem.OSVersionProperty.BUILDNUMBER, 0));
            this.setVersion(this.parseVersion(versionInfo, suiteMask));
            this.setCodeName(this.parseCodeName(suiteMask));
            LOG.debug("Initialized OSVersionInfoEx");
        }
    }

    protected void handleNoVersionInfo() {
        LOG.warn("No version data available.");
        this.setVersion(System.getProperty("os.version"));
        this.setCodeName("");
        this.setBuildNumber("");
    }

    private String parseVersion(WbemcliUtil.WmiResult<Win32OperatingSystem.OSVersionProperty> versionInfo, int suiteMask) {
        String version = System.getProperty("os.version");
        String[] verSplit = WmiUtil.getString(versionInfo, Win32OperatingSystem.OSVersionProperty.VERSION, 0).split("\\D");
        int major = verSplit.length > 0 ? ParseUtil.parseIntOrDefault(verSplit[0], 0) : 0;
        int minor = verSplit.length > 1 ? ParseUtil.parseIntOrDefault(verSplit[1], 0) : 0;
        boolean ntWorkstation = WmiUtil.getUint32(versionInfo, Win32OperatingSystem.OSVersionProperty.PRODUCTTYPE, 0) == 1;
        switch (major) {
            case 10: {
                if (minor != 0) break;
                if (ntWorkstation) {
                    version = "10";
                    break;
                }
                version = ParseUtil.parseLongOrDefault(this.getBuildNumber(), 0L) > 17762L ? "Server 2019" : "Server 2016";
                break;
            }
            case 6: {
                if (minor == 3) {
                    version = ntWorkstation ? "8.1" : "Server 2012 R2";
                    break;
                }
                if (minor == 2) {
                    version = ntWorkstation ? "8" : "Server 2012";
                    break;
                }
                if (minor == 1) {
                    version = ntWorkstation ? "7" : "Server 2008 R2";
                    break;
                }
                if (minor != 0) break;
                version = ntWorkstation ? "Vista" : "Server 2008";
                break;
            }
            case 5: {
                if (minor == 2) {
                    if ((suiteMask & 0x8000) != 0) {
                        version = "Home Server";
                        break;
                    }
                    if (ntWorkstation) {
                        version = "XP";
                        break;
                    }
                    version = User32.INSTANCE.GetSystemMetrics(89) != 0 ? "Server 2003" : "Server 2003 R2";
                    break;
                }
                if (minor == 1) {
                    version = "XP";
                    break;
                }
                if (minor != 0) break;
                version = "2000";
                break;
            }
        }
        String sp = WmiUtil.getString(versionInfo, Win32OperatingSystem.OSVersionProperty.CSDVERSION, 0);
        if (!sp.isEmpty() && !"unknown".equals(sp)) {
            version = version + " " + sp.replace("Service Pack ", "SP");
        }
        return version;
    }

    private String parseCodeName(int suiteMask) {
        ArrayList<String> suites = new ArrayList<String>();
        if ((suiteMask & 2) != 0) {
            suites.add("Enterprise");
        }
        if ((suiteMask & 4) != 0) {
            suites.add("BackOffice");
        }
        if ((suiteMask & 8) != 0) {
            suites.add("Communication Server");
        }
        if ((suiteMask & 0x80) != 0) {
            suites.add("Datacenter");
        }
        if ((suiteMask & 0x200) != 0) {
            suites.add("Home");
        }
        if ((suiteMask & 0x400) != 0) {
            suites.add("Web Server");
        }
        if ((suiteMask & 0x2000) != 0) {
            suites.add("Storage Server");
        }
        if ((suiteMask & 0x4000) != 0) {
            suites.add("Compute Cluster");
        }
        return String.join((CharSequence)",", suites);
    }
}

