/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.util.ParseUtil;

public interface CentralProcessor {
    public ProcessorIdentifier getProcessorIdentifier();

    @Deprecated
    public String getVendor();

    @Deprecated
    public String getName();

    @Deprecated
    public String getFamily();

    @Deprecated
    public String getModel();

    @Deprecated
    public String getStepping();

    @Deprecated
    public String getProcessorID();

    @Deprecated
    public String getIdentifier();

    @Deprecated
    public boolean isCpu64bit();

    @Deprecated
    public long getVendorFreq();

    public long getMaxFreq();

    public long[] getCurrentFreq();

    public LogicalProcessor[] getLogicalProcessors();

    public double getSystemCpuLoadBetweenTicks(long[] var1);

    public long[] getSystemCpuLoadTicks();

    public double[] getSystemLoadAverage(int var1);

    public double[] getProcessorCpuLoadBetweenTicks(long[][] var1);

    public long[][] getProcessorCpuLoadTicks();

    public int getLogicalProcessorCount();

    public int getPhysicalProcessorCount();

    public int getPhysicalPackageCount();

    public long getContextSwitches();

    public long getInterrupts();

    public static final class ProcessorIdentifier {
        private final String cpuVendor;
        private final String cpuName;
        private final String cpuFamily;
        private final String cpuModel;
        private final String cpuStepping;
        private final String processorID;
        private final String cpuIdentifier;
        private final boolean cpu64bit;
        private final long cpuVendorFreq;

        public ProcessorIdentifier(String cpuVendor, String cpuName, String cpuFamily, String cpuModel, String cpuStepping, String processorID, boolean cpu64bit) {
            this.cpuVendor = cpuVendor;
            this.cpuName = cpuName;
            this.cpuFamily = cpuFamily;
            this.cpuModel = cpuModel;
            this.cpuStepping = cpuStepping;
            this.processorID = processorID;
            this.cpu64bit = cpu64bit;
            StringBuilder sb = new StringBuilder();
            if (cpuVendor.contentEquals("GenuineIntel")) {
                sb.append(cpu64bit ? "Intel64" : "x86");
            } else {
                sb.append(cpuVendor);
            }
            sb.append(" Family ").append(cpuFamily);
            sb.append(" Model ").append(cpuModel);
            sb.append(" Stepping ").append(cpuStepping);
            this.cpuIdentifier = sb.toString();
            Pattern pattern = Pattern.compile("@ (.*)$");
            Matcher matcher = pattern.matcher(cpuName);
            if (matcher.find()) {
                String unit = matcher.group(1);
                this.cpuVendorFreq = ParseUtil.parseHertz(unit);
            } else {
                this.cpuVendorFreq = -1L;
            }
        }

        public String getVendor() {
            return this.cpuVendor;
        }

        public String getName() {
            return this.cpuName;
        }

        public String getFamily() {
            return this.cpuFamily;
        }

        public String getModel() {
            return this.cpuModel;
        }

        public String getStepping() {
            return this.cpuStepping;
        }

        public String getProcessorID() {
            return this.processorID;
        }

        public String getIdentifier() {
            return this.cpuIdentifier;
        }

        public boolean isCpu64bit() {
            return this.cpu64bit;
        }

        public long getVendorFreq() {
            return this.cpuVendorFreq;
        }

        public String toString() {
            return this.getIdentifier();
        }
    }

    public static class LogicalProcessor {
        private final int processorNumber;
        private final int physicalProcessorNumber;
        private final int physicalPackageNumber;
        private final int numaNode;
        private final int processorGroup;

        public LogicalProcessor(int processorNumber, int physicalProcessorNumber, int physicalPackageNumber) {
            this(processorNumber, physicalProcessorNumber, physicalPackageNumber, 0, 0);
        }

        public LogicalProcessor(int processorNumber, int physicalProcessorNumber, int physicalPackageNumber, int numaNode) {
            this(processorNumber, physicalProcessorNumber, physicalPackageNumber, numaNode, 0);
        }

        public LogicalProcessor(int processorNumber, int physicalProcessorNumber, int physicalPackageNumber, int numaNode, int processorGroup) {
            this.processorNumber = processorNumber;
            this.physicalProcessorNumber = physicalProcessorNumber;
            this.physicalPackageNumber = physicalPackageNumber;
            this.numaNode = numaNode;
            this.processorGroup = processorGroup;
        }

        public int getProcessorNumber() {
            return this.processorNumber;
        }

        public int getPhysicalProcessorNumber() {
            return this.physicalProcessorNumber;
        }

        public int getPhysicalPackageNumber() {
            return this.physicalPackageNumber;
        }

        public int getNumaNode() {
            return this.numaNode;
        }

        public int getProcessorGroup() {
            return this.processorGroup;
        }
    }

    public static enum TickType {
        USER(0),
        NICE(1),
        SYSTEM(2),
        IDLE(3),
        IOWAIT(4),
        IRQ(5),
        SOFTIRQ(6),
        STEAL(7);

        private int index;

        private TickType(int value) {
            this.index = value;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

