/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import com.alibaba.fastjson2.reader.FieldReaderObject;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.function.BiConsumer;

final class FieldReaderObjectFunc<T, V>
extends FieldReaderImpl<T>
implements FieldReaderObject<T, V> {
    final Method method;
    final BiConsumer<T, V> function;
    protected ObjectReader fieldObjectReader;

    FieldReaderObjectFunc(String fieldName, Type fieldType, Class<V> fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema, Method method, BiConsumer<T, V> function, ObjectReader fieldObjectReader) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, schema);
        this.method = method;
        this.function = function;
        this.fieldObjectReader = fieldObjectReader;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public ObjectReader getInitReader() {
        return this.fieldObjectReader;
    }

    @Override
    public void accept(T object, Object value) {
        if (this.fieldType == Float.class) {
            value = TypeUtils.toFloat(value);
        } else if (this.fieldType == Double.class) {
            value = TypeUtils.toDouble(value);
        }
        if (value == null && this.fieldClass == StackTraceElement[].class) {
            return;
        }
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        this.function.accept(object, value);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        ObjectReader objectReader = this.fieldObjectReader != null ? this.fieldObjectReader : (this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType));
        if (jsonReader.isReference()) {
            String reference = jsonReader.readReference();
            if ("..".equals(reference)) {
                this.accept(object, object);
            } else {
                this.addResolveTask(jsonReader, object, reference);
            }
            return;
        }
        Object value = jsonReader.isJSONB() ? objectReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, this.features) : objectReader.readObject(jsonReader, this.fieldType, this.fieldName, this.features);
        this.accept(object, value);
    }

    @Override
    public ObjectReader getFieldObjectReader(JSONReader.Context context) {
        if (this.fieldObjectReader == null) {
            this.fieldObjectReader = context.getObjectReader(this.fieldType);
        }
        return this.fieldObjectReader;
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        ObjectReader objectReader = this.fieldObjectReader != null ? this.fieldObjectReader : (this.fieldObjectReader = jsonReader.getContext().getObjectReader(this.fieldType));
        return jsonReader.isJSONB() ? objectReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, this.features) : objectReader.readObject(jsonReader, this.fieldType, this.fieldName, this.features);
    }
}

