/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.service;

import cn.langpy.kotime.model.MethodNode;
import cn.langpy.kotime.util.Context;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.StringUtils;

public class EmailSendService
extends JavaMailSenderImpl {
    private static Logger log = Logger.getLogger(EmailSendService.class.toString());
    private static ConcurrentMap<String, Integer> redMethods = new ConcurrentHashMap<String, Integer>();
    private static final ExecutorService emailExecutors = Executors.newFixedThreadPool(5);
    @Value(value="${ko-time.mail-receivers:}")
    private String receivers;
    @Value(value="${ko-time.mail-threshold:4}")
    private Integer threshold;
    @Value(value="${ko-time.data-prefix:}")
    private String dataPrefix;
    @Value(value="${ko-time.mail-user:}")
    private String user;

    public void sendNoticeAsync(MethodNode current) {
        emailExecutors.submit(() -> this.sendNotice(current));
    }

    public void sendNotice(MethodNode current) {
        if (!StringUtils.hasText((String)this.receivers)) {
            return;
        }
        if (redMethods.containsKey(current.getId())) {
            int n = (Integer)redMethods.get(current.getId());
            if (++n >= this.threshold) {
                this.send(this.createMessage(current));
                redMethods.put(current.getId(), -2000);
            } else {
                redMethods.put(current.getId(), n);
            }
        } else {
            redMethods.put(current.getId(), 1);
            if (this.threshold == 1) {
                this.send(this.createMessage(current));
            }
        }
    }

    private MimeMessage createMessage(MethodNode current) {
        MimeMessage mimeMessage = null;
        try {
            mimeMessage = this.createMimeMessage();
            this.configMessage(current, mimeMessage);
        }
        catch (MessagingException e) {
            log.severe("Error email message!");
        }
        return mimeMessage;
    }

    private void configMessage(MethodNode current, MimeMessage mimeMessage) throws MessagingException {
        String[] receiversArray = this.receivers.split(",");
        MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true);
        messageHelper.setSubject("KoTime\u8017\u65f6\u9884\u8b66-" + this.dataPrefix + "-" + current.getName());
        messageHelper.setFrom(this.user);
        messageHelper.setTo(receiversArray);
        messageHelper.setSentDate(new Date());
        messageHelper.setText(this.createNoticeTemplate(current), true);
    }

    private String createNoticeTemplate(MethodNode current) {
        return "<h4>\u60a8\u6709\u4e00\u4e2a\u65b9\u6cd5\u8017\u65f6\u6709" + this.threshold + "\u6b21\u8d85\u8fc7\u4e86\u9608\u503c\uff08" + Context.getConfig().getThreshold() + "\uff09\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a</h4>\n<div style=\"background-color: #fafdfd;border-radius: 5px;width: 600px;padding: 10px;box-shadow: #75f1bf 2px 2px 2px 2px\">\n    <div>\u9879\u76ee\uff1a" + this.dataPrefix + "</div>\n    <div>\u7c7b\u540d\uff1a" + current.getClassName() + "</div>\n    <div>\u65b9\u6cd5\uff1a" + current.getMethodName() + "</div>\n    <div>\u6700\u8fd1\u8017\u65f6\uff1a" + current.getValue() + " ms</div>\n</div>\n<p>\u8bf7\u524d\u5f80\u7cfb\u7edf\u67e5\u770b</p>\n<p>" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")) + "</p>";
    }
}

