/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.config;

import cn.langpy.kotime.annotation.KoListener;
import cn.langpy.kotime.config.DefaultConfig;
import cn.langpy.kotime.handler.InvokedHandler;
import cn.langpy.kotime.handler.RunTimeHandler;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.service.InvokedQueue;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.DataBaseException;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@ComponentScan(value={"cn.langpy.kotime"})
@Configuration
public class LoadConfig {
    private static Logger log = Logger.getLogger(LoadConfig.class.toString());
    @Value(value="${koTime.enable:true}")
    private Boolean kotimeEnable;
    @Value(value="${koTime.log.language:chinese}")
    private String logLanguage;
    @Value(value="${koTime.log.enable:false}")
    private Boolean logEnable;
    @Value(value="${koTime.time.threshold:800.0}")
    private Double timeThreshold;
    @Value(value="${koTime.pointcut:execution(* cn.langpy.kotime.controller.KoTimeController.*(..))}")
    private String pointcut;
    @Value(value="${koTime.exception.enable:false}")
    private Boolean exceptionEnable;
    @Value(value="${koTime.saver:memory}")
    private String saveSaver;
    @Value(value="${koTime.thread-num:2}")
    private Integer threadNum;
    @Value(value="${server.port:8080}")
    private Integer serverPort;
    @Value(value="${server.servlet.context-path:}")
    private String serverContext;
    @Resource
    private DefaultConfig defaultConfig;
    @Resource
    private ApplicationContext applicationContext;

    @PostConstruct
    public void initConfig() {
        String[] names;
        DefaultConfig config = new DefaultConfig();
        config.setLogEnable(this.defaultConfig.getLogEnable() == null ? this.logEnable : this.defaultConfig.getLogEnable());
        config.setLogLanguage(this.defaultConfig.getLogLanguage() == null ? this.logLanguage : this.defaultConfig.getLogLanguage());
        config.setThreshold(this.defaultConfig.getThreshold() == null ? this.timeThreshold : this.defaultConfig.getThreshold());
        config.setExceptionEnable(this.defaultConfig.getExceptionEnable() == null ? this.exceptionEnable : this.defaultConfig.getExceptionEnable());
        config.setSaver(this.defaultConfig.getSaver() == null ? this.saveSaver : this.defaultConfig.getSaver());
        config.setEnable(this.defaultConfig.getEnable() == null ? this.kotimeEnable : this.defaultConfig.getEnable());
        config.setDataPrefix(this.defaultConfig.getDataPrefix() == null ? (StringUtils.hasText((String)this.serverContext) ? this.serverContext.substring(1) : "KOTIME") : this.defaultConfig.getDataPrefix());
        config.setContextPath(this.defaultConfig.getContextPath());
        config.setLanguage(this.defaultConfig.getLanguage() == null ? "chinese" : this.defaultConfig.getLanguage());
        config.setThreadNum(this.defaultConfig.getThreadNum() == null ? 2 : this.defaultConfig.getThreadNum());
        config.setAuthEnable(this.defaultConfig.getAuthEnable() == null ? false : this.defaultConfig.getAuthEnable());
        config.setParamAnalyse(this.defaultConfig.getParamAnalyse() == null ? true : this.defaultConfig.getParamAnalyse());
        config.setDataReset(this.defaultConfig.getDataReset() == null ? false : this.defaultConfig.getDataReset());
        this.configDataSource(config);
        this.configRedisTemplate(config);
        Context.setConfig(config);
        for (String name : names = this.applicationContext.getBeanNamesForType(GraphService.class)) {
            GraphService bean = (GraphService)this.applicationContext.getBean(name);
            if (null == bean) continue;
            Component annotation = bean.getClass().getAnnotation(Component.class);
            if (!config.getSaver().equals(annotation.value())) continue;
            Context.setSaver(bean);
            break;
        }
        if (null == Context.getSaver()) {
            throw new DataBaseException("error `ko-time.saver=" + config.getSaver() + "`, and you can only choose an option in {memory,database,redis} for `ko-time.saver=`!");
        }
        log.info("kotime=>loading config");
        if (StringUtils.hasText((String)config.getContextPath())) {
            log.info("kotime=>view:" + Context.getConfig().getContextPath() + "/koTime");
        } else {
            log.info("kotime=>view:http://localhost:" + this.serverPort + this.serverContext + "/koTime");
        }
        this.initMethodHandlers();
    }

    public void configDataSource(DefaultConfig config) {
        if (!"database".equals(config.getSaver())) {
            return;
        }
        try {
            DataSource dataSource = (DataSource)this.applicationContext.getBean(DataSource.class);
            Context.setDataSource(dataSource);
        }
        catch (NoUniqueBeanDefinitionException e) {
            if (StringUtils.isEmpty((Object)config.getDataSource())) {
                log.severe("kotime=>No unique bean of type 'DataSource' available,you can define it by `ko-time.data-source=xxx`");
            } else {
                DataSource dataSource = (DataSource)this.applicationContext.getBean(config.getDataSource(), DataSource.class);
                Context.setDataSource(dataSource);
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            log.severe("kotime=>No qualifying bean of type 'DataSource' available,but you can ignore it if your KoTime saver is `ko-time.saver=memory`");
        }
    }

    public void configRedisTemplate(DefaultConfig config) {
        if (!"redis".equals(config.getSaver())) {
            return;
        }
        try {
            StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
            Context.setStringRedisTemplate(redisTemplate);
        }
        catch (NoUniqueBeanDefinitionException e) {
            if (!StringUtils.isEmpty((Object)config.getRedisTemplate())) {
                StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(config.getRedisTemplate(), StringRedisTemplate.class);
                Context.setStringRedisTemplate(redisTemplate);
            } else {
                Map beansOfType = this.applicationContext.getBeansOfType(StringRedisTemplate.class);
                log.warning("kotime=>No unique bean of type 'StringRedisTemplate' available,you can define it by `ko-time.redis-template=xxx`,and you can choose a name in " + beansOfType.keySet().stream().collect(Collectors.toList()));
                log.warning("kotime=>Now the firsr was be set.");
                Context.setStringRedisTemplate((StringRedisTemplate)beansOfType.values().stream().collect(Collectors.toList()).get(0));
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            log.severe("kotime=>No qualifying bean of type 'StringRedisTemplate' available,but you can ignore it if your KoTime saver is `ko-time.saver=memory`");
        }
        catch (NoClassDefFoundError error) {
            log.severe("kotime=>No dependency named `spring-boot-starter-data-redis` found,please add a denpendency in pom.xml for redis.");
        }
    }

    public void initMethodHandlers() {
        String[] names;
        for (String name : names = this.applicationContext.getBeanNamesForType(InvokedHandler.class)) {
            KoListener annotation;
            InvokedHandler bean = (InvokedHandler)this.applicationContext.getBean(name);
            if (null == bean || null == (annotation = bean.getClass().getAnnotation(KoListener.class))) continue;
            log.info("kotime=>loading InvokedHandler:" + bean.getClass().getSimpleName());
            Context.addInvokedHandler(bean);
        }
        for (int i = 0; i < Context.getConfig().getThreadNum(); ++i) {
            new Thread(() -> InvokedQueue.onInveked()).start();
        }
    }

    @Bean
    public AspectJExpressionPointcutAdvisor configurabledvisor() {
        log.info("kotime=>loading method listener");
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        String cutRange = this.defaultConfig.getPointcut() == null ? this.pointcut : this.defaultConfig.getPointcut();
        cutRange = cutRange + " && !@annotation(cn.langpy.kotime.annotation.KoListener)";
        advisor.setExpression(cutRange);
        advisor.setAdvice((Advice)new RunTimeHandler());
        return advisor;
    }
}

