/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.data;

import cn.langpy.kotime.model.ExceptionInfo;
import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.ExceptionRelation;
import cn.langpy.kotime.model.MethodInfo;
import cn.langpy.kotime.model.MethodNode;
import cn.langpy.kotime.model.MethodRelation;
import cn.langpy.kotime.model.ParamMetric;
import cn.langpy.kotime.model.SystemStatistic;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.util.Common;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.MethodType;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="memory")
public class MemoryBase
implements GraphService {
    private static volatile Map<String, MethodNode> methodNodes = new HashMap<String, MethodNode>();
    private static volatile Map<String, ExceptionNode> exceptions = new HashMap<String, ExceptionNode>();
    private static volatile Map<String, MethodRelation> methodRelations = new HashMap<String, MethodRelation>();
    private static volatile Map<String, ExceptionRelation> exceptionRelations = new HashMap<String, ExceptionRelation>();
    private static volatile Map<String, Map<String, ParamMetric>> paramValueMetricMap = new HashMap<String, Map<String, ParamMetric>>();

    @Override
    public void addMethodNode(MethodNode methodNode) {
        if (null == methodNode) {
            return;
        }
        if (!methodNodes.containsKey(methodNode.getId())) {
            methodNodes.put(methodNode.getId(), methodNode);
        } else if (methodNode.getMethodType() == MethodType.Controller && !StringUtils.isEmpty((Object)methodNode.getRouteName())) {
            MethodNode controller = methodNodes.get(methodNode.getId());
            controller.setRouteName(methodNode.getRouteName());
            methodNodes.put(methodNode.getId(), controller);
        }
    }

    @Override
    public void addParamAnalyse(String methodId, Parameter[] names, Object[] values, double v) {
        String paramsKey = Common.getPramsStr(names, values);
        if (paramValueMetricMap.containsKey(methodId)) {
            Map<String, ParamMetric> paramMetricMap = paramValueMetricMap.get(methodId);
            if (paramMetricMap.containsKey(paramsKey)) {
                ParamMetric paramMetric = paramMetricMap.get(paramsKey);
                BigDecimal bg = BigDecimal.valueOf((paramMetric.getAvgRunTime() + v) / 2.0);
                double avg = bg.setScale(2, 4).doubleValue();
                paramMetric.setAvgRunTime(avg);
                if (v > paramMetric.getMaxRunTime()) {
                    paramMetric.setMaxRunTime(v);
                }
                if (v < paramMetric.getMinRunTime()) {
                    paramMetric.setMinRunTime(v);
                }
            } else {
                ParamMetric paramMetric = new ParamMetric();
                paramMetric.setMaxRunTime(v);
                paramMetric.setAvgRunTime(v);
                paramMetric.setMaxRunTime(v);
                paramMetricMap.put(paramsKey, paramMetric);
            }
        } else {
            ParamMetric paramMetric = new ParamMetric();
            paramMetric.setMaxRunTime(v);
            paramMetric.setAvgRunTime(v);
            paramMetric.setMaxRunTime(v);
            HashMap<String, ParamMetric> paramMetricMap = new HashMap<String, ParamMetric>();
            paramMetricMap.put(paramsKey, paramMetric);
            paramValueMetricMap.put(methodId, paramMetricMap);
        }
    }

    @Override
    public MethodRelation addMethodRelation(MethodNode sourceMethodNode, MethodNode targetMethodNode) {
        if (null == sourceMethodNode || null == targetMethodNode) {
            return null;
        }
        if (sourceMethodNode.getId().equals(targetMethodNode.getId())) {
            return null;
        }
        if (methodRelations.containsKey(targetMethodNode.getId() + sourceMethodNode.getId())) {
            return null;
        }
        MethodRelation methodRelation = new MethodRelation();
        methodRelation.setSourceId(sourceMethodNode.getId());
        methodRelation.setTargetId(targetMethodNode.getId());
        methodRelation.setId(sourceMethodNode.getId() + targetMethodNode.getId());
        methodRelation.setAvgRunTime(targetMethodNode.getValue());
        methodRelation.setMaxRunTime(targetMethodNode.getValue());
        methodRelation.setMinRunTime(targetMethodNode.getValue());
        MethodRelation old = methodRelations.get(methodRelation.getId());
        if (null == old) {
            methodRelations.put(methodRelation.getId(), methodRelation);
            return methodRelation;
        }
        BigDecimal bg = BigDecimal.valueOf((methodRelation.getAvgRunTime() + old.getAvgRunTime()) / 2.0);
        double avg = bg.setScale(2, 4).doubleValue();
        old.setAvgRunTime(avg);
        old.setMaxRunTime(methodRelation.getMaxRunTime() > old.getMaxRunTime() ? methodRelation.getMaxRunTime() : old.getMaxRunTime());
        old.setMinRunTime(methodRelation.getMinRunTime() < old.getMinRunTime() ? methodRelation.getMinRunTime() : old.getMinRunTime());
        return old;
    }

    @Override
    public ExceptionRelation addExceptionRelation(MethodNode sourceMethodNode, ExceptionNode exceptionNode) {
        ExceptionRelation exceptionRelation = new ExceptionRelation();
        exceptionRelation.setId(sourceMethodNode.getId() + exceptionNode.getId());
        exceptionRelation.setSourceId(sourceMethodNode.getId());
        exceptionRelation.setTargetId(exceptionNode.getId());
        exceptionRelation.setLocation(exceptionNode.getValue());
        ExceptionRelation old = exceptionRelations.get(exceptionRelation.getId());
        if (null == old) {
            exceptionRelations.put(exceptionRelation.getId(), exceptionRelation);
            return exceptionRelation;
        }
        return old;
    }

    @Override
    public void addExceptionNode(ExceptionNode exceptionNode) {
        if (!exceptions.containsKey(exceptionNode.getId())) {
            exceptions.put(exceptionNode.getId(), exceptionNode);
        }
    }

    @Override
    public List<ExceptionInfo> getExceptions(String methodId) {
        ArrayList<ExceptionInfo> exceptionInfos = new ArrayList<ExceptionInfo>();
        List relations = exceptionRelations.values().stream().filter(exceptionRelation -> exceptionRelation.getSourceId().equals(methodId)).collect(Collectors.toList());
        for (ExceptionRelation relation : relations) {
            String exceptionId = relation.getTargetId();
            ExceptionNode exceptionNode = exceptions.get(exceptionId);
            ExceptionInfo exceptionInfo = new ExceptionInfo();
            exceptionInfo.setId(exceptionNode.getId());
            exceptionInfo.setName(exceptionNode.getName());
            exceptionInfo.setClassName(exceptionNode.getClassName());
            exceptionInfo.setMessage(exceptionNode.getMessage());
            exceptionInfo.setLocation(relation.getLocation());
            if (exceptionInfos.contains(exceptionInfo)) continue;
            exceptionInfos.add(exceptionInfo);
        }
        return exceptionInfos;
    }

    @Override
    public List<ExceptionNode> getExceptions() {
        return exceptions.values().stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<MethodInfo> getControllers() {
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        for (MethodNode methodNode : methodNodes.values()) {
            if (MethodType.Controller != methodNode.getMethodType()) continue;
            String id = methodNode.getId();
            Optional<MethodRelation> relations = methodRelations.values().stream().filter(methodRelation -> methodRelation.getTargetId().equals(id)).findFirst();
            MethodRelation relation = null;
            if (!relations.isPresent()) continue;
            relation = relations.get();
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.setId(methodNode.getId());
            methodInfo.setName(methodNode.getName());
            methodInfo.setClassName(methodNode.getClassName());
            methodInfo.setMethodName(methodNode.getMethodName());
            methodInfo.setMethodType(methodNode.getMethodType());
            methodInfo.setRouteName(methodNode.getRouteName());
            methodInfo.setValue(relation.getAvgRunTime());
            methodInfo.setAvgRunTime(relation.getAvgRunTime());
            methodInfo.setMaxRunTime(relation.getMaxRunTime());
            methodInfo.setMinRunTime(relation.getMinRunTime());
            if (methodInfos.contains(methodInfo)) continue;
            methodInfos.add(methodInfo);
        }
        return methodInfos;
    }

    @Override
    public Map<String, ParamMetric> getMethodParamGraph(String methodId) {
        Map<String, ParamMetric> paramMetricMap = paramValueMetricMap.get(methodId);
        return paramMetricMap;
    }

    @Override
    public List<MethodInfo> searchMethods(String question) {
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        for (MethodNode methodNode : methodNodes.values()) {
            if (!methodNode.getName().toLowerCase().contains(question.toLowerCase())) continue;
            String id = methodNode.getId();
            Optional<MethodRelation> relations = methodRelations.values().stream().filter(methodRelation -> methodRelation.getTargetId().equals(id)).findFirst();
            MethodRelation relation = null;
            if (!relations.isPresent()) continue;
            relation = relations.get();
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.setId(methodNode.getId());
            methodInfo.setName(methodNode.getName());
            methodInfo.setClassName(methodNode.getClassName());
            methodInfo.setMethodName(methodNode.getMethodName());
            methodInfo.setMethodType(methodNode.getMethodType());
            methodInfo.setRouteName(methodNode.getRouteName());
            methodInfo.setValue(relation.getAvgRunTime());
            methodInfo.setAvgRunTime(relation.getAvgRunTime());
            methodInfo.setMaxRunTime(relation.getMaxRunTime());
            methodInfo.setMinRunTime(relation.getMinRunTime());
            if (methodInfos.contains(methodInfo)) continue;
            methodInfos.add(methodInfo);
        }
        return methodInfos;
    }

    @Override
    public List<String> getCondidates(String question) {
        ArrayList<String> methodInfos = new ArrayList<String>();
        for (MethodNode methodNode : methodNodes.values()) {
            if (methodNode.getName().toLowerCase().contains(question.toLowerCase()) && !methodInfos.contains(methodNode.getName())) {
                methodInfos.add(methodNode.getName());
            }
            if (methodInfos.size() < 10) continue;
            break;
        }
        return methodInfos;
    }

    @Override
    public List<ExceptionInfo> getExceptionInfos(String exceptionId) {
        ArrayList<ExceptionInfo> exceptionInfos = new ArrayList<ExceptionInfo>();
        for (ExceptionRelation relation : exceptionRelations.values()) {
            if (!relation.getTargetId().equals(exceptionId)) continue;
            String sourceMethodId = relation.getSourceId();
            MethodNode methodNode = methodNodes.get(sourceMethodId);
            ExceptionNode exceptionNode = exceptions.get(exceptionId);
            ExceptionInfo exceptionInfo = new ExceptionInfo();
            exceptionInfo.setId(exceptionNode.getId());
            exceptionInfo.setName(exceptionNode.getName());
            exceptionInfo.setClassName(exceptionNode.getClassName());
            exceptionInfo.setLocation(relation.getLocation());
            exceptionInfo.setMessage(exceptionNode.getMessage());
            exceptionInfo.setMethodName(methodNode.getMethodName());
            exceptionInfo.setOccurClassName(methodNode.getClassName());
            if (exceptionInfos.contains(exceptionInfo)) continue;
            exceptionInfos.add(exceptionInfo);
        }
        return exceptionInfos;
    }

    @Override
    public List<MethodInfo> getChildren(String methodId) {
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        for (MethodRelation methodRelation : methodRelations.values()) {
            if (!methodRelation.getSourceId().equals(methodId)) continue;
            String targetMethodId = methodRelation.getTargetId();
            MethodNode methodNode = methodNodes.get(targetMethodId);
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.setId(methodNode.getId());
            methodInfo.setName(methodNode.getName());
            methodInfo.setClassName(methodNode.getClassName());
            methodInfo.setMethodName(methodNode.getMethodName());
            methodInfo.setRouteName(methodNode.getRouteName());
            methodInfo.setMethodType(methodNode.getMethodType());
            methodInfo.setValue(methodRelation.getAvgRunTime());
            methodInfo.setAvgRunTime(methodRelation.getAvgRunTime());
            methodInfo.setMaxRunTime(methodRelation.getMaxRunTime());
            methodInfo.setMinRunTime(methodRelation.getMinRunTime());
            List<ExceptionInfo> exceptionInfos = this.getExceptions(methodNode.getId());
            methodInfo.setExceptionNum(exceptionInfos.size());
            methodInfo.setExceptions(exceptionInfos);
            if (methodInfos.contains(methodInfo)) continue;
            methodInfos.add(methodInfo);
        }
        return methodInfos;
    }

    @Override
    public SystemStatistic getRunStatistic() {
        SystemStatistic systemStatistic = new SystemStatistic();
        List<MethodInfo> controllerApis = this.getControllers();
        if (null == controllerApis || controllerApis.size() == 0) {
            return systemStatistic;
        }
        int delayNum = (int)controllerApis.stream().filter(controllerApi -> controllerApi.getAvgRunTime() >= Context.getConfig().getThreshold()).count();
        systemStatistic.setDelayNum(delayNum);
        int normalNum = (int)controllerApis.stream().filter(controllerApi -> controllerApi.getAvgRunTime() < Context.getConfig().getThreshold()).count();
        systemStatistic.setNormalNum(normalNum);
        int totalNum = (int)controllerApis.stream().count();
        systemStatistic.setTotalNum(totalNum);
        Double max = controllerApis.stream().map(api -> api.getAvgRunTime()).max(Double::compareTo).get();
        Double min = controllerApis.stream().map(api -> api.getAvgRunTime()).min(Double::compareTo).get();
        Double avg = controllerApis.stream().map(api -> api.getAvgRunTime()).collect(Collectors.averagingDouble(Double::doubleValue));
        BigDecimal bg = BigDecimal.valueOf(avg);
        avg = bg.setScale(2, 4).doubleValue();
        systemStatistic.setMaxRunTime(max);
        systemStatistic.setMinRunTime(min);
        systemStatistic.setAvgRunTime(avg);
        return systemStatistic;
    }

    @Override
    public MethodInfo getTree(String methodId) {
        MethodInfo rootInfo = new MethodInfo();
        MethodNode methodNode = methodNodes.get(methodId);
        rootInfo.setId(methodNode.getId());
        rootInfo.setName(methodNode.getName());
        rootInfo.setClassName(methodNode.getClassName());
        rootInfo.setMethodName(methodNode.getMethodName());
        rootInfo.setMethodType(methodNode.getMethodType());
        rootInfo.setRouteName(methodNode.getRouteName());
        MethodRelation methodRelation = methodRelations.values().stream().filter(relation -> relation.getTargetId().equals(methodId)).findFirst().get();
        rootInfo.setValue(methodRelation.getAvgRunTime());
        rootInfo.setAvgRunTime(methodRelation.getAvgRunTime());
        rootInfo.setMaxRunTime(methodRelation.getMaxRunTime());
        rootInfo.setMinRunTime(methodRelation.getMinRunTime());
        List<ExceptionInfo> exceptionInfos = this.getExceptions(methodId);
        rootInfo.setExceptionNum(exceptionInfos.size());
        rootInfo.setExceptions(exceptionInfos);
        ArrayList<String> methodInfos = new ArrayList<String>();
        this.recursionMethod(rootInfo, methodInfos);
        methodInfos.clear();
        return rootInfo;
    }

    public void recursionMethod(MethodInfo rootInfo, List<String> methodInfos) {
        List<MethodInfo> children = this.getChildren(rootInfo.getId());
        if (children != null && children.size() > 0 && !methodInfos.contains(rootInfo.getId())) {
            methodInfos.add(rootInfo.getId());
            rootInfo.setChildren(children);
            for (MethodInfo child : children) {
                this.recursionMethod(child, methodInfos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearAll() {
        MemoryBase memoryBase = this;
        synchronized (memoryBase) {
            methodNodes.clear();
            exceptions.clear();
            methodRelations.clear();
            exceptionRelations.clear();
            paramValueMetricMap.clear();
        }
        return true;
    }
}

