/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.data;

import cn.langpy.kotime.model.ExceptionInfo;
import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.ExceptionRelation;
import cn.langpy.kotime.model.MethodInfo;
import cn.langpy.kotime.model.MethodNode;
import cn.langpy.kotime.model.MethodRelation;
import cn.langpy.kotime.model.ParamAna;
import cn.langpy.kotime.model.ParamMetric;
import cn.langpy.kotime.model.SystemStatistic;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.util.Common;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.DataBaseException;
import cn.langpy.kotime.util.DataBaseUtil;
import cn.langpy.kotime.util.MethodType;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="database")
@Lazy
public class DataBase
implements GraphService {
    private static Logger log = Logger.getLogger(DataBase.class.toString());
    private Connection readConnection;
    private Connection writeConnection;

    public DataBase() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (null != this.readConnection) {
                    this.readConnection.close();
                }
                if (null != this.writeConnection) {
                    this.writeConnection.close();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            finally {
                log.info("kotime=>closed database connections...");
            }
        }));
        this.initConnection();
    }

    public void initConnection() {
        this.getReadConnection();
        this.getWriteConnection();
    }

    public Connection getReadConnection() {
        try {
            if (null == this.readConnection || this.readConnection.isClosed()) {
                DataSource dataSource = Context.getDataSource();
                if (null == dataSource) {
                    if ("database".equals(Context.getConfig().getSaver())) {
                        throw new DataBaseException("`ko-time.saver=database` needs a DataSource for MySQl or Oracle, or you can use `ko-time.saver=memory` to store data!");
                    }
                } else {
                    this.readConnection = dataSource.getConnection();
                }
            }
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return this.readConnection;
    }

    public Connection getWriteConnection() {
        try {
            if (null == this.writeConnection || this.writeConnection.isClosed()) {
                DataSource dataSource = Context.getDataSource();
                if (null == dataSource) {
                    if ("database".equals(Context.getConfig().getSaver())) {
                        throw new DataBaseException("`ko-time.saver=database` needs a DataSource for MySQl or Oracle, or you can use `ko-time.saver=memory` to store data!");
                    }
                } else {
                    this.writeConnection = dataSource.getConnection();
                }
            }
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return this.writeConnection;
    }

    @Override
    public void addMethodNode(MethodNode methodNode) {
        if (null == methodNode) {
            return;
        }
        boolean existsById = DataBaseUtil.existsById(this.getWriteConnection(), "SELECT id, name, class_name, method_name, route_name, method_type FROM ko_method_node  WHERE id=?", methodNode.getId());
        if (!existsById) {
            Object[] params = new Object[]{methodNode.getId(), methodNode.getName(), methodNode.getClassName(), methodNode.getMethodName(), methodNode.getRouteName(), methodNode.getMethodType().name()};
            DataBaseUtil.insert(this.getWriteConnection(), "INSERT INTO ko_method_node(id, name, class_name, method_name, route_name, method_type) VALUES (?, ?, ?, ?, ?, ?)", params);
        } else if (methodNode.getMethodType() == MethodType.Controller && !StringUtils.isEmpty((Object)methodNode.getRouteName())) {
            Object[] params = new Object[]{methodNode.getName(), methodNode.getClassName(), methodNode.getMethodName(), methodNode.getRouteName(), methodNode.getMethodType().name(), methodNode.getId()};
            DataBaseUtil.update(this.getWriteConnection(), "UPDATE ko_method_node SET name=?, class_name=?, method_name=?, route_name=?, method_type=? WHERE id=?", params);
        }
    }

    @Override
    public synchronized void addExceptionNode(ExceptionNode exceptionNode) {
        boolean existsById = DataBaseUtil.existsById(this.getWriteConnection(), "SELECT id, name, class_name, message FROM ko_exception_node  WHERE id=?", exceptionNode.getId());
        if (!existsById) {
            Object[] params = new Object[]{exceptionNode.getId(), exceptionNode.getName(), exceptionNode.getClassName(), exceptionNode.getMessage()};
            DataBaseUtil.insert(this.getWriteConnection(), "INSERT INTO ko_exception_node(id, name, class_name, message) VALUES (?, ?, ?, ?)", params);
        }
    }

    @Override
    public synchronized MethodRelation addMethodRelation(MethodNode sourceMethodNode, MethodNode targetMethodNode) {
        if (null == sourceMethodNode || null == targetMethodNode) {
            return null;
        }
        if (sourceMethodNode.getId().equals(targetMethodNode.getId())) {
            return null;
        }
        try {
            List<Map<String, Object>> query = DataBaseUtil.query(this.getWriteConnection(), "SELECT id, source_id, target_id, avg_run_time, max_run_time, min_run_time FROM ko_method_relation WHERE id=?", new Object[]{sourceMethodNode.getId() + targetMethodNode.getId()});
            if (query.size() > 0) {
                Map<String, Object> old = query.get(0);
                double oldAvg = Double.valueOf(old.get("avg_run_time") + "");
                double oldMax = Double.valueOf(old.get("max_run_time") + "");
                double oldMin = Double.valueOf(old.get("min_run_time") + "");
                BigDecimal bg = BigDecimal.valueOf((targetMethodNode.getValue() + oldAvg) / 2.0);
                double avg = bg.setScale(2, 4).doubleValue();
                double max = targetMethodNode.getValue() > oldMax ? targetMethodNode.getValue() : oldMax;
                double min = targetMethodNode.getValue() < oldMin ? targetMethodNode.getValue() : oldMin;
                Object[] params = new Object[]{sourceMethodNode.getId(), targetMethodNode.getId(), avg, max, min, sourceMethodNode.getId() + targetMethodNode.getId()};
                DataBaseUtil.update(this.getWriteConnection(), "UPDATE ko_method_relation SET source_id=?, target_id=?, avg_run_time=?, max_run_time=?, min_run_time=? WHERE id=?", params);
                return null;
            }
            Object[] params = new Object[]{sourceMethodNode.getId() + targetMethodNode.getId(), sourceMethodNode.getId(), targetMethodNode.getId(), targetMethodNode.getValue(), targetMethodNode.getValue(), targetMethodNode.getValue()};
            DataBaseUtil.insert(this.getWriteConnection(), "INSERT INTO ko_method_relation(id, source_id, target_id, avg_run_time, max_run_time, min_run_time) VALUES (?, ?, ?, ?, ?, ?)", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public synchronized ExceptionRelation addExceptionRelation(MethodNode sourceMethodNode, ExceptionNode exceptionNode) {
        boolean existsById = DataBaseUtil.existsById(this.getWriteConnection(), "SELECT id, source_id, target_id, location FROM ko_exception_relation WHERE id=?", sourceMethodNode.getId() + exceptionNode.getId());
        if (!existsById) {
            Object[] params = new Object[]{sourceMethodNode.getId() + exceptionNode.getId(), sourceMethodNode.getId(), exceptionNode.getId(), exceptionNode.getValue()};
            DataBaseUtil.insert(this.getWriteConnection(), "INSERT INTO ko_exception_relation(id, source_id, target_id, location) VALUES (?, ?, ?, ?)", params);
        }
        return null;
    }

    @Override
    public synchronized void addParamAnalyse(String methodId, Parameter[] names, Object[] values, double v) {
        String paramsKey = Common.getPramsStr(names, values);
        List<Map<String, Object>> query = DataBaseUtil.query(this.getWriteConnection(), "SELECT source_id, params, avg_run_time, max_run_time, min_run_time FROM ko_param_ana WHERE source_id=? and params=?", new Object[]{methodId, paramsKey});
        if (query.size() == 0) {
            Object[] params = new Object[]{methodId, paramsKey, v, v, v};
            DataBaseUtil.insert(this.getWriteConnection(), "INSERT INTO ko_param_ana (source_id, params, avg_run_time, max_run_time, min_run_time) VALUES (?, ?, ?, ?, ?)", params);
        } else {
            Map<String, Object> old = query.get(0);
            double oldAvg = Double.valueOf(old.get("avg_run_time") + "");
            double oldMax = Double.valueOf(old.get("max_run_time") + "");
            double oldMin = Double.valueOf(old.get("min_run_time") + "");
            BigDecimal bg = BigDecimal.valueOf((v + oldAvg) / 2.0);
            double avg = bg.setScale(2, 4).doubleValue();
            double max = v > oldMax ? v : oldMax;
            double min = v < oldMin ? v : oldMin;
            Object[] params = new Object[]{avg, max, min, methodId, paramsKey};
            DataBaseUtil.update(this.getWriteConnection(), "UPDATE ko_param_ana SET avg_run_time=?, max_run_time=?, min_run_time=?  WHERE source_id=? and params=?", params);
        }
    }

    @Override
    public MethodInfo getTree(String methodId) {
        MethodInfo rootInfo = new MethodInfo();
        List<MethodNode> methodNodes = DataBaseUtil.query(this.getReadConnection(), "SELECT id, name, class_name, method_name, route_name, method_type FROM ko_method_node  WHERE id=?", new Object[]{methodId}, MethodNode.class);
        if (methodNodes.size() == 0) {
            return rootInfo;
        }
        MethodNode methodNode = methodNodes.get(0);
        rootInfo.setId(methodNode.getId());
        rootInfo.setName(methodNode.getName());
        rootInfo.setClassName(methodNode.getClassName());
        rootInfo.setMethodName(methodNode.getMethodName());
        rootInfo.setMethodType(methodNode.getMethodType());
        rootInfo.setRouteName(methodNode.getRouteName());
        List<MethodRelation> relations = DataBaseUtil.query(this.getReadConnection(), "SELECT id, source_id, target_id, avg_run_time, max_run_time, min_run_time FROM ko_method_relation WHERE target_id=?", new Object[]{methodId}, MethodRelation.class);
        if (relations.size() == 0) {
            return rootInfo;
        }
        MethodRelation methodRelation = relations.get(0);
        rootInfo.setValue(methodRelation.getAvgRunTime());
        rootInfo.setAvgRunTime(methodRelation.getAvgRunTime());
        rootInfo.setMaxRunTime(methodRelation.getMaxRunTime());
        rootInfo.setMinRunTime(methodRelation.getMinRunTime());
        List<ExceptionInfo> exceptionInfos = this.getExceptions(methodId);
        rootInfo.setExceptionNum(exceptionInfos.size());
        rootInfo.setExceptions(exceptionInfos);
        ArrayList<String> methodInfos = new ArrayList<String>();
        this.recursionMethod(rootInfo, methodInfos);
        methodInfos.clear();
        return rootInfo;
    }

    public void recursionMethod(MethodInfo rootInfo, List<String> methodInfos) {
        List<MethodInfo> children = this.getChildren(rootInfo.getId());
        if (children != null && children.size() > 0 && !methodInfos.contains(rootInfo.getId())) {
            methodInfos.add(rootInfo.getId());
            rootInfo.setChildren(children);
            for (MethodInfo child : children) {
                this.recursionMethod(child, methodInfos);
            }
        }
    }

    @Override
    public Map<String, ParamMetric> getMethodParamGraph(String methodId) {
        HashMap<String, ParamMetric> paramMetricMap = new HashMap<String, ParamMetric>();
        List<ParamAna> paramAnas = DataBaseUtil.query(this.getReadConnection(), "SELECT source_id, params, avg_run_time, max_run_time, min_run_time FROM ko_param_ana WHERE source_id=?", new Object[]{methodId}, ParamAna.class);
        if (paramAnas.size() == 0) {
            return paramMetricMap;
        }
        for (ParamAna paramAna : paramAnas) {
            if (paramMetricMap.containsKey(paramAna.getSourceId())) continue;
            ParamMetric paramMetric = new ParamMetric();
            paramMetric.setAvgRunTime(paramAna.getAvgRunTime());
            paramMetric.setMaxRunTime(paramAna.getMaxRunTime());
            paramMetric.setMinRunTime(paramAna.getMinRunTime());
            paramMetricMap.put(paramAna.getParams(), paramMetric);
        }
        return paramMetricMap;
    }

    @Override
    public SystemStatistic getRunStatistic() {
        SystemStatistic systemStatistic = new SystemStatistic();
        List<MethodInfo> controllerApis = this.getControllers();
        if (null == controllerApis || controllerApis.size() == 0) {
            return systemStatistic;
        }
        int delayNum = 0;
        int totalNum = controllerApis.size();
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        double avg = controllerApis.get(0).getAvgRunTime();
        for (MethodInfo controllerApi : controllerApis) {
            double avgRunTime = controllerApi.getAvgRunTime();
            if (avgRunTime >= Context.getConfig().getThreshold()) {
                ++delayNum;
            }
            if (avgRunTime > max) {
                max = avgRunTime;
            }
            if (avgRunTime < min) {
                min = avgRunTime;
            }
            avg = (avgRunTime + avg) / 2.0;
        }
        systemStatistic.setDelayNum(delayNum);
        systemStatistic.setNormalNum(totalNum - delayNum);
        systemStatistic.setTotalNum(totalNum);
        BigDecimal bg = BigDecimal.valueOf(avg);
        avg = bg.setScale(2, 4).doubleValue();
        systemStatistic.setMaxRunTime(max);
        systemStatistic.setMinRunTime(min);
        systemStatistic.setAvgRunTime(avg);
        return systemStatistic;
    }

    @Override
    public List<MethodInfo> getControllers() {
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        List<MethodInfo> controllers = DataBaseUtil.query(this.getReadConnection(), "SELECT id, name, class_name, method_name, route_name, method_type FROM ko_method_node  WHERE method_type=?", new Object[]{MethodType.Controller.name()}, MethodInfo.class);
        for (MethodInfo methodNode : controllers) {
            String id = methodNode.getId();
            List<MethodRelation> relations = DataBaseUtil.query(this.getReadConnection(), "SELECT id, source_id, target_id, avg_run_time, max_run_time, min_run_time FROM ko_method_relation WHERE target_id=?", new Object[]{id}, MethodRelation.class);
            if (relations.size() == 0) continue;
            MethodRelation relation = relations.get(0);
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.setId(methodNode.getId());
            methodInfo.setName(methodNode.getName());
            methodInfo.setClassName(methodNode.getClassName());
            methodInfo.setMethodName(methodNode.getMethodName());
            methodInfo.setMethodType(methodNode.getMethodType());
            methodInfo.setRouteName(methodNode.getRouteName());
            methodInfo.setValue(relation.getAvgRunTime());
            methodInfo.setAvgRunTime(relation.getAvgRunTime());
            methodInfo.setMaxRunTime(relation.getMaxRunTime());
            methodInfo.setMinRunTime(relation.getMinRunTime());
            if (methodInfos.contains(methodInfo)) continue;
            methodInfos.add(methodInfo);
        }
        return methodInfos;
    }

    @Override
    public List<String> getCondidates(String question) {
        List<MethodNode> methodNodes = DataBaseUtil.query(this.getReadConnection(), "SELECT id, name, class_name, method_name, route_name, method_type FROM ko_method_node  WHERE name like ?", new Object[]{"%" + question + "%"}, MethodNode.class);
        List<String> methodInfos = new ArrayList<String>();
        if (methodNodes.size() > 0) {
            methodInfos = methodNodes.stream().map(MethodNode::getName).collect(Collectors.toList());
        }
        return methodInfos;
    }

    @Override
    public List<MethodInfo> searchMethods(String question) {
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        List<MethodNode> methodNodes = DataBaseUtil.query(this.getReadConnection(), "SELECT id, name, class_name, method_name, route_name, method_type FROM ko_method_node  WHERE name like ?", new Object[]{"%" + question + "%"}, MethodNode.class);
        for (MethodNode methodNode : methodNodes) {
            String id = methodNode.getId();
            List<MethodRelation> relations = DataBaseUtil.query(this.getReadConnection(), "SELECT id, source_id, target_id, avg_run_time, max_run_time, min_run_time FROM ko_method_relation WHERE target_id=?", new Object[]{id}, MethodRelation.class);
            if (relations.size() == 0) continue;
            MethodRelation relation = relations.get(0);
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.setId(methodNode.getId());
            methodInfo.setName(methodNode.getName());
            methodInfo.setClassName(methodNode.getClassName());
            methodInfo.setMethodName(methodNode.getMethodName());
            methodInfo.setMethodType(methodNode.getMethodType());
            methodInfo.setRouteName(methodNode.getRouteName());
            methodInfo.setValue(relation.getAvgRunTime());
            methodInfo.setAvgRunTime(relation.getAvgRunTime());
            methodInfo.setMaxRunTime(relation.getMaxRunTime());
            methodInfo.setMinRunTime(relation.getMinRunTime());
            if (methodInfos.contains(methodInfo)) continue;
            methodInfos.add(methodInfo);
        }
        return methodInfos;
    }

    @Override
    public List<MethodInfo> getChildren(String methodId) {
        List<MethodRelation> relations = DataBaseUtil.query(this.getReadConnection(), "SELECT id, source_id, target_id, avg_run_time, max_run_time, min_run_time FROM ko_method_relation WHERE source_id=?", new Object[]{methodId}, MethodRelation.class);
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        for (MethodRelation methodRelation : relations) {
            List<MethodNode> methodNodes = DataBaseUtil.query(this.getReadConnection(), "SELECT id, name, class_name, method_name, route_name, method_type FROM ko_method_node  WHERE id=?", new Object[]{methodRelation.getTargetId()}, MethodNode.class);
            if (methodNodes.size() == 0) continue;
            MethodNode methodNode = methodNodes.get(0);
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.setId(methodNode.getId());
            methodInfo.setName(methodNode.getName());
            methodInfo.setClassName(methodNode.getClassName());
            methodInfo.setMethodName(methodNode.getMethodName());
            methodInfo.setRouteName(methodNode.getRouteName());
            methodInfo.setMethodType(methodNode.getMethodType());
            methodInfo.setValue(methodRelation.getAvgRunTime());
            methodInfo.setAvgRunTime(methodRelation.getAvgRunTime());
            methodInfo.setMaxRunTime(methodRelation.getMaxRunTime());
            methodInfo.setMinRunTime(methodRelation.getMinRunTime());
            List<ExceptionInfo> exceptionInfos = this.getExceptions(methodNode.getId());
            methodInfo.setExceptionNum(exceptionInfos.size());
            methodInfo.setExceptions(exceptionInfos);
            if (methodInfos.contains(methodInfo)) continue;
            methodInfos.add(methodInfo);
        }
        return methodInfos;
    }

    @Override
    public List<ExceptionInfo> getExceptionInfos(String exceptionId) {
        List<ExceptionRelation> relations = DataBaseUtil.query(this.getReadConnection(), "SELECT id, source_id, target_id, location FROM ko_exception_relation WHERE target_id=?", new Object[]{exceptionId}, ExceptionRelation.class);
        ArrayList<ExceptionInfo> exceptionInfos = new ArrayList<ExceptionInfo>();
        for (ExceptionRelation relation : relations) {
            String sourceMethodId = relation.getSourceId();
            List<MethodNode> methodNodes = DataBaseUtil.query(this.getReadConnection(), "SELECT id, name, class_name, method_name, route_name, method_type FROM ko_method_node  WHERE id=?", new Object[]{sourceMethodId}, MethodNode.class);
            if (methodNodes.size() == 0) continue;
            MethodNode methodNode = methodNodes.get(0);
            List<ExceptionNode> exceptions = DataBaseUtil.query(this.getReadConnection(), "SELECT id, name, class_name, method_name, route_name, method_type FROM ko_method_node  WHERE id=?", new Object[]{exceptionId}, ExceptionNode.class);
            if (methodNodes.size() == 0) continue;
            ExceptionNode exceptionNode = exceptions.get(0);
            ExceptionInfo exceptionInfo = new ExceptionInfo();
            exceptionInfo.setId(exceptionNode.getId());
            exceptionInfo.setName(exceptionNode.getName());
            exceptionInfo.setClassName(exceptionNode.getClassName());
            exceptionInfo.setLocation(relation.getLocation());
            exceptionInfo.setMessage(exceptionNode.getMessage());
            exceptionInfo.setMethodName(methodNode.getMethodName());
            exceptionInfo.setOccurClassName(methodNode.getClassName());
            if (exceptionInfos.contains(exceptionInfo)) continue;
            exceptionInfos.add(exceptionInfo);
        }
        return exceptionInfos;
    }

    @Override
    public List<ExceptionInfo> getExceptions(String methodId) {
        ArrayList<ExceptionInfo> exceptionInfos = new ArrayList<ExceptionInfo>();
        List<ExceptionRelation> relations = DataBaseUtil.query(this.getReadConnection(), "SELECT id, source_id, target_id, location FROM ko_exception_relation WHERE target_id=?", new Object[]{methodId}, ExceptionRelation.class);
        for (ExceptionRelation relation : relations) {
            String exceptionId = relation.getTargetId();
            List<ExceptionNode> exceptionNodes = DataBaseUtil.query(this.getReadConnection(), "SELECT id, name, class_name, message FROM ko_exception_node  WHERE id=?", new Object[]{exceptionId}, ExceptionNode.class);
            if (exceptionNodes.size() == 0) continue;
            ExceptionNode exceptionNode = exceptionNodes.get(0);
            ExceptionInfo exceptionInfo = new ExceptionInfo();
            exceptionInfo.setId(exceptionNode.getId());
            exceptionInfo.setName(exceptionNode.getName());
            exceptionInfo.setClassName(exceptionNode.getClassName());
            exceptionInfo.setMessage(exceptionNode.getMessage());
            exceptionInfo.setLocation(relation.getLocation());
            if (exceptionInfos.contains(exceptionInfo)) continue;
            exceptionInfos.add(exceptionInfo);
        }
        return exceptionInfos;
    }

    @Override
    public List<ExceptionNode> getExceptions() {
        List<ExceptionNode> exceptionNodes = DataBaseUtil.query(this.getReadConnection(), "SELECT id, name, class_name, message FROM ko_exception_node", null, ExceptionNode.class);
        return exceptionNodes;
    }
}

