/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.service;

import cn.langpy.kotime.data.MemoryBase;
import cn.langpy.kotime.data.MysqlBase;
import cn.langpy.kotime.model.ExceptionInfo;
import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.ExceptionRelation;
import cn.langpy.kotime.model.MethodInfo;
import cn.langpy.kotime.model.MethodNode;
import cn.langpy.kotime.model.MethodRelation;
import cn.langpy.kotime.model.ParamMetric;
import cn.langpy.kotime.model.SystemStatistic;
import cn.langpy.kotime.util.Context;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;

public interface GraphService {
    public static GraphService getInstance() {
        GraphService graphService = null;
        if (Context.getConfig().getSaveSaver().equals("memory")) {
            graphService = new MemoryBase();
        } else if (Context.getConfig().getSaveSaver().equals("mysql")) {
            graphService = new MysqlBase();
        }
        return graphService;
    }

    public void addMethodNode(MethodNode var1);

    public void addParamAnalyse(String var1, Parameter[] var2, Object[] var3, double var4);

    public void addExceptionNode(ExceptionNode var1);

    public MethodInfo getTree(String var1);

    public Map<String, ParamMetric> getMethodParamGraph(String var1);

    public SystemStatistic getRunStatistic();

    public List<MethodInfo> searchMethods(String var1);

    public List<MethodInfo> getControllers();

    public List<String> getCondidates(String var1);

    public List<MethodInfo> getChildren(String var1);

    public List<ExceptionInfo> getExceptionInfos(String var1);

    public List<ExceptionInfo> getExceptions(String var1);

    public List<ExceptionNode> getExceptions();

    public MethodRelation addMethodRelation(MethodNode var1, MethodNode var2);

    public ExceptionRelation addExceptionRelation(MethodNode var1, ExceptionNode var2);
}

