/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.config;

import cn.langpy.kotime.config.DefaultConfig;
import cn.langpy.kotime.handler.RunTimeHandler;
import cn.langpy.kotime.util.Context;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@ComponentScan(value={"cn.langpy.kotime"})
@Configuration
public class LoadConfig {
    public static Logger log = Logger.getLogger(LoadConfig.class.toString());
    @Value(value="${koTime.enable:true}")
    private Boolean kotimeEnable;
    @Value(value="${koTime.log.language:chinese}")
    private String logLanguage;
    @Value(value="${koTime.log.enable:false}")
    private Boolean logEnable;
    @Value(value="${koTime.time.threshold:800.0}")
    private Double timeThreshold;
    @Value(value="${koTime.pointcut:execution(* cn.langpy.kotime.controller.KoTimeController.*(..))}")
    private String pointcut;
    @Value(value="${koTime.exception.enable:false}")
    private Boolean exceptionEnable;
    @Value(value="${koTime.save.saver:memory}")
    private String saveSaver;
    @Value(value="${koTime.save.async:false}")
    private Boolean saveAsync;
    @Value(value="${koTime.save.thread-num:4}")
    private Integer threadNum;
    @Value(value="${server.port:8080}")
    private Integer serverPort;
    @Value(value="${server.servlet.context-path:}")
    private String serverContext;
    @Resource
    private DefaultConfig defaultConfig;

    @PostConstruct
    public void function() {
        DefaultConfig config = new DefaultConfig();
        config.setLogEnable(this.defaultConfig.getLogEnable() == null ? this.logEnable : this.defaultConfig.getLogEnable());
        config.setPointcut(this.defaultConfig.getPointcut() == null ? this.pointcut : this.defaultConfig.getPointcut());
        config.setLogLanguage(this.defaultConfig.getLogLanguage() == null ? this.logLanguage : this.defaultConfig.getLogLanguage());
        config.setThreshold(this.defaultConfig.getThreshold() == null ? this.timeThreshold : this.defaultConfig.getThreshold());
        config.setExceptionEnable(this.defaultConfig.getExceptionEnable() == null ? this.exceptionEnable : this.defaultConfig.getExceptionEnable());
        config.setSaveSaver(this.defaultConfig.getSaveSaver() == null ? this.saveSaver : this.defaultConfig.getSaveSaver());
        config.setEnable(this.defaultConfig.getEnable() == null ? this.kotimeEnable : this.defaultConfig.getEnable());
        config.setContextPath(this.defaultConfig.getContextPath());
        config.setAuthEnable(this.defaultConfig.getAuthEnable() == null ? false : this.defaultConfig.getAuthEnable());
        Context.setConfig(config);
        log.info("kotime=>loading config");
        if (StringUtils.hasText((String)config.getContextPath())) {
            log.info("kotime=>view:" + Context.getConfig().getContextPath() + "/koTime");
        } else {
            log.info("kotime=>view:http://localhost:" + this.serverPort + this.serverContext + "/koTime");
        }
    }

    @Bean
    public AspectJExpressionPointcutAdvisor configurabledvisor() {
        log.info("kotime=>loading method listener");
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        advisor.setExpression(this.defaultConfig.getPointcut() == null ? this.pointcut : this.defaultConfig.getPointcut());
        advisor.setAdvice((Advice)new RunTimeHandler());
        return advisor;
    }
}

