/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.controller;

import cn.langpy.kotime.annotation.Auth;
import cn.langpy.kotime.config.DefaultConfig;
import cn.langpy.kotime.model.ExceptionInfo;
import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.MethodInfo;
import cn.langpy.kotime.model.SystemStatistic;
import cn.langpy.kotime.model.UserInfo;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.InvalidAuthInfoException;
import cn.langpy.kotime.util.KoUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/koTime"})
public class KoTimeController {
    @Value(value="${ko-time.user-name:}")
    private String userName;
    @Value(value="${ko-time.password:}")
    private String password;
    public static Logger log = Logger.getLogger(KoTimeController.class.toString());

    @PostMapping(value={"/login"})
    @ResponseBody
    public Map login(@RequestBody UserInfo userInfo) {
        if (null == userInfo || !StringUtils.hasText((String)userInfo.getUserName()) || !StringUtils.hasText((String)userInfo.getPassword())) {
            throw new InvalidAuthInfoException("failed to login for kotime,please fill userName and password!");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.userName.equals(userInfo.getUserName()) && this.password.equals(userInfo.getPassword())) {
            String token = KoUtil.login(userInfo.getUserName());
            map.put("state", 1);
            map.put("token", token);
            return map;
        }
        map.put("state", 0);
        return map;
    }

    @GetMapping(value={"/isLogin"})
    @ResponseBody
    public Map isLogin(String token) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("state", 1);
        boolean checkLogin = KoUtil.isLogin(token);
        map.put("isLogin", checkLogin ? 1 : 0);
        return map;
    }

    @GetMapping
    public void index(String test, HttpServletResponse response, HttpServletRequest request) throws Exception {
        if (null != test) {
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        ClassPathResource classPathResource = new ClassPathResource("kotime.html");
        BufferedReader reader = new BufferedReader(new InputStreamReader(classPathResource.getInputStream(), "utf-8"));
        PrintWriter out = response.getWriter();
        String context = request.getContextPath();
        if (StringUtils.hasText((String)Context.getConfig().getContextPath())) {
            context = Context.getConfig().getContextPath();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String line = "";
        int n = 0;
        while ((line = reader.readLine()) != null) {
            if (n > 14) {
                if (line.indexOf("globalThresholdValue") > -1) {
                    line = line.replace("globalThresholdValue", Context.getConfig().getThreshold() + "");
                } else if (line.indexOf("globalNeedLoginValue") > -1) {
                    line = line.replace("globalNeedLoginValue", Context.getConfig().getAuthEnable() + "");
                } else if (line.indexOf("contextPath") > -1) {
                    line = line.replace("contextPath", context);
                } else if (line.indexOf("exceptionTitleStyle") > -1) {
                    line = line.replace("exceptionTitleStyle", Context.getConfig().getExceptionEnable() == true ? "" : "display:none;");
                }
                stringBuilder.append(line + "\n");
            } else {
                stringBuilder.append(line + "\n");
            }
            ++n;
        }
        line = stringBuilder.toString();
        out.write(line);
        out.close();
    }

    @GetMapping(value={"/getConfig"})
    @ResponseBody
    @Auth
    public DefaultConfig getConfig() {
        return Context.getConfig();
    }

    @GetMapping(value={"/getStatistic"})
    @ResponseBody
    @Auth
    public SystemStatistic getStatistic() {
        GraphService graphService = GraphService.getInstance();
        SystemStatistic system = graphService.getRunStatistic();
        return system;
    }

    @GetMapping(value={"/getApis"})
    @ResponseBody
    @Auth
    public List<MethodInfo> getApis(String question) {
        GraphService graphService = GraphService.getInstance();
        List<MethodInfo> list = null;
        list = StringUtils.hasText((String)question) ? graphService.searchMethods(question) : graphService.getControllers();
        Collections.sort(list);
        return list;
    }

    @GetMapping(value={"/getApiTips"})
    @ResponseBody
    @Auth
    public List<String> getApiTips(String question) {
        GraphService graphService = GraphService.getInstance();
        List<String> list = graphService.getCondidates(question);
        return list;
    }

    @GetMapping(value={"/getExceptions"})
    @ResponseBody
    @Auth
    public List<ExceptionNode> getExceptions() {
        GraphService graphService = GraphService.getInstance();
        List<ExceptionNode> exceptionList = graphService.getExceptions();
        return exceptionList;
    }

    @GetMapping(value={"/getTree"})
    @ResponseBody
    @Auth
    public MethodInfo getTree(String methodName) {
        GraphService graphService = GraphService.getInstance();
        return graphService.getTree(methodName);
    }

    @GetMapping(value={"/getMethodsByExceptionId"})
    @ResponseBody
    @Auth
    public List<ExceptionInfo> getMethodsByExceptionId(String exceptionId) {
        GraphService graphService = GraphService.getInstance();
        return graphService.getExceptionInfos(exceptionId);
    }

    @PostMapping(value={"/updateConfig"})
    @ResponseBody
    @Auth
    public boolean updateConfig(@RequestBody DefaultConfig config) {
        DefaultConfig koTimeConfig = Context.getConfig();
        if (config.getEnable() != null) {
            koTimeConfig.setEnable(config.getEnable());
        }
        if (config.getExceptionEnable() != null) {
            koTimeConfig.setExceptionEnable(config.getExceptionEnable());
        }
        if (config.getLogEnable() != null) {
            koTimeConfig.setLogEnable(config.getLogEnable());
        }
        if (config.getThreshold() != null) {
            koTimeConfig.setThreshold(config.getThreshold());
        }
        return true;
    }
}

