
function MetricFlow(domId,options) {
    let styleDom = document.getElementsByTagName("style")[0];
    if (styleDom!=undefined) {
        styleDom.innerHTML += '.ko-node{position:absolute;background-color:#5f665f;border:2px solid #4b804b;border-radius:5px;width:auto;}.ko-node .ko-node-title{padding-left:17px;padding-right:10px;background-color:#4b804b;color:white;}.ko-node .ko-node-body{list-style:none;margin-top:5px;}.ko-node li{padding-right:10px;margin-left:-23px;color:white;border-bottom:1px solid lightslategray;padding-bottom:2px;font-size:10px;}';
    }else {
        let style = document.createElement('style');
        style.type = 'text/css';
        style.rel = 'stylesheet';
        style.appendChild(document.createTextNode(".ko-node{position:absolute;background-color:#5f665f;border:2px solid #4b804b;border-radius:5px;width:auto;}.ko-node .ko-node-title{padding-left:17px;padding-right:10px;background-color:#4b804b;color:white;}.ko-node .ko-node-body{list-style:none;margin-top:5px;}.ko-node li{padding-right:10px;margin-left:-23px;color:white;border-bottom:1px solid lightslategray;padding-bottom:2px;font-size:10px;}"));
        let head = document.getElementsByTagName('head')[0];
        head.appendChild(style);
    };
    let o = new Object();
    o.allNodes = new Map();
    o.back = document.getElementById(domId);
    o.back.className='ko-node-back';
    let backWidth = Number(o.back.getAttribute("width").replace("px","").replace("%",""))*2;
    let backHeight = Number(o.back.getAttribute("height").replace("px","").replace("%",""))*1.5;
    o.back.innerHTML='<div id="methods"></div>\n    <svg id="svgBack" class="ko-node-back"  xmlns="http://www.w3.org/2000/svg" version="1.1" height="'+backHeight+'" width="'+backWidth+'" zdrive="true" cbor="false">\n        <g id="points" stroke="#4b804b" stroke-width="4" fill="white"></g>\n        <g id="relations" stroke="#4b804b" stroke-width="3" fill="none"></g>\n        <defs>\n            <marker id=\'arrow\' markerWidth=\'13\' markerHeight=\'13\' refx=\'6\' refy=\'7\' orient=\'auto\'>\n                <path d=\'M2,10 L6,7 L2,4 L2,10\' style=\'fill:#4b804b\'/>\n            </marker>\n        </defs>\n    </svg>';
    o.svgBack = document.getElementById("svgBack");
    o.nodesBack = document.getElementById("methods");
    o.points = document.getElementById("points");
    o.relations = document.getElementById("relations");


    o.createNode = function (param, x, y) {
        if (o.allNodes.get(param['id']) != undefined) {
            let node = document.getElementById(param['id']);
            return node;
        };
        let nodeText = "<div id='idValue' style='top:topValuepx!important;left:leftValuepx!important;background-color: nodeBackgroundColor;border: 2px solid nodeBorderColor' class='ko-node'>" +
            "              <div class='ko-node-title' style='color: titleColor;background-color: titleBackColor'>dataTitle</div>" +
            "                  <ul class='ko-node-body'>" +
            "                      liBody" +
            "                  </ul>" +
            "           </div>";

        let liText = '';
        let liTextTemp = '<li class="ko-node-li" style="background-color: liBackColor">LiText</li>';
        for (let index in param.data) {
            let liBackColor = param.data[index]['background-color'] || '#5f665f';
            liText+= liTextTemp.replace('LiText',param.data[index]['name']).replace('liBackColor',liBackColor);
        };
        let titleColor = param['title']['color'] || 'white';
        let titleBackColor = param['title']['background-color'] || '#4b804b';
        let nodeBackgroundColor = param['background-color'] || '#5f665f';
        let nodeBorderColor = param['border-color'] || '#4b804b';
        nodeText= nodeText
            .replace('nodeBorderColor',nodeBorderColor)
            .replace('nodeBackgroundColor',nodeBackgroundColor)
            .replace('titleColor',titleColor)
            .replace('titleBackColor',titleBackColor)
            .replace('dataTitle',param['title']['name'])
            .replace('idValue',param['id'])
            .replace('topValue',(param['y'] || y))
            .replace('leftValue',(param['x'] || x))
            .replace('liBody',liText);
        o.nodesBack .innerHTML+=nodeText;
        let node = document.getElementById(param['id']);
        node.setAttribute('x',(param['x'] || x));
        node.setAttribute('y',(param['y'] || y));
        node.setAttribute('width',node.offsetWidth);
        node.setAttribute('height',node.offsetHeight);

        let nodeObject = new Map();
        nodeObject.set("ins",new Array());
        nodeObject.set("outs",new Array());
        nodeObject.set("node",node);
        o.allNodes.set(node.id,nodeObject);
        return node;
    };

    o.createSimLink= function (source, target) {
        let sourceTop = Number(source.getAttribute("y"));
        let sourceLeft = Number(source.getAttribute("x"));
        var sourceWidth = Number(source.getAttribute("width"));
        var sourceHeight = Number(source.getAttribute("height"));

        let targetTop = Number(target.getAttribute("y"));
        let targetLeft = Number(target.getAttribute("x"));
        var targetHeight = Number(target.getAttribute("height"));

        o.points.innerHTML += "<circle id='pointstart"+source.getAttribute("id")+target.getAttribute("id")+"' cx='"+(sourceLeft+sourceWidth-3)+"' cy='"+(sourceTop+sourceHeight/2-4)+"' r='4' />";
        o.points.innerHTML += "<circle id='pointend"+source.getAttribute("id")+target.getAttribute("id")+"' cx='"+(targetLeft-11)+"' cy='"+(targetTop+targetHeight/2-4)+"' r='4' />";


        startX = (sourceLeft+sourceWidth)+2;
        startY = (sourceTop+sourceHeight/2-4);
        endX = targetLeft-14;
        endY = (targetTop+targetHeight/2-4);

        o.relations.innerHTML += "<line id='line-"+source.id+"-"+target.id+"' x1='"+startX+"' y1='"+startY+"' x2='"+endX+"' y2='"+endY+"' marker-end='url(#arrow)'/>";
    };

    o.createLink= function (source, target) {
        let sourceOuts = o.allNodes.get(source.id).get("outs");
        let targetIns = o.allNodes.get(target.id).get("ins");
        if (sourceOuts.indexOf("line"+source.id+target.id)>-1) {
            return ;
        };
        let sourceTop = Number(source.getAttribute("y"));
        let sourceLeft = Number(source.getAttribute("x"));
        var sourceWidth = Number(source.getAttribute("width"));
        var sourceHeight = Number(source.getAttribute("height"));

        let targetTop = Number(target.getAttribute("y"));
        let targetLeft = Number(target.getAttribute("x"));
        var targetHeight = Number(target.getAttribute("height"));

        o.points.innerHTML += "<circle id='pointstart"+source.getAttribute("id")+target.getAttribute("id")+"' cx='"+(sourceLeft+sourceWidth-3)+"' cy='"+(sourceTop+sourceHeight/2-4)+"' r='4' />";
        o.points.innerHTML += "<circle id='pointend"+source.getAttribute("id")+target.getAttribute("id")+"' cx='"+(targetLeft-11)+"' cy='"+(targetTop+targetHeight/2-4)+"' r='4' />";


        startX = (sourceLeft+sourceWidth)+2;
        startY = (sourceTop+sourceHeight/2-4);
        endX = targetLeft-14;
        endY = (targetTop+targetHeight/2-4);

        o.relations.innerHTML += "<line id='line-"+source.id+"-"+target.id+"' x1='"+startX+"' y1='"+startY+"' x2='"+endX+"' y2='"+endY+"' marker-end='url(#arrow)'/>";
        sourceOuts.push('line-'+source.id+'-'+target.id);
        targetIns.push('line-'+source.id+'-'+target.id);
    };
    function getMouseTarget(eventElement){
        let clssName = eventElement.getAttribute('class');
        if (clssName=='ko-node') {
            return eventElement;
        }else if (clssName=='ko-node-li') {
            return eventElement.parentNode.parentNode;
        }else if (clssName=='ko-node-title') {
            return eventElement.parentNode;
        }else if (clssName=='ko-node-body') {
            return eventElement.parentNode;
        }else {
            return eventElement;
        };
    };
    function reDrawNodeLines(node){
        let objectData = o.allNodes.get(node.id);
        if (objectData==undefined) {
            return;
        };
        let inIds = objectData.get("ins");
        for (let index in inIds) {
            let lineId = inIds[index];
            let lineIdSplit = lineId.split('-');
            let sourceId = lineIdSplit[1];
            let targetId = lineIdSplit[2];
            if (document.getElementById(lineId) != undefined){
                document.getElementById(lineId).remove();
                document.getElementById('pointstart'+sourceId+targetId).remove();
                document.getElementById('pointend'+sourceId+targetId).remove();
                o.createSimLink(document.getElementById(sourceId),node);
            };
        };

        let outIds = o.allNodes.get(node.id).get("outs");
        for (let index in outIds) {
            let lineId = outIds[index];
            let lineIdSplit = lineId.split('-');
            let sourceId = lineIdSplit[1];
            let targetId = lineIdSplit[2];
            if (document.getElementById(lineId) != undefined){
                document.getElementById(lineId).remove();
                document.getElementById('pointstart'+sourceId+targetId).remove();
                document.getElementById('pointend'+sourceId+targetId).remove();
                o.createSimLink(node,document.getElementById(targetId));
            };
        };
    };

    o.reDrawLines = function (){
        o.allNodes.forEach(function(nodeData,nodeId){
            reDrawNodeLines(document.getElementById(nodeId));
        });
    };

    o.moveNode;
    o.moveNodeX = 0;
    o.moveNodeY = 0;
    o.back.onmousedown = function (e) {
        let mouseTarget = getMouseTarget(e.target);
        let clssName = mouseTarget.getAttribute('class');
        o.moveNodeX = e.clientX;
        o.moveNodeY = e.clientY;
        if (clssName=='ko-node') {
            o.moveNode = mouseTarget;
            o.moveNode.style.cursor = 'move';
            o.moveNode.onmousemove = nodeMove;
            o.moveNode.onmouseup = nodeMoveClose;
        };
    };
    o.svgBack.onmousedown = function (e) {
        let mouseTarget = getMouseTarget(e.target);
        let clssName = mouseTarget.getAttribute('class');
        o.moveNodeX = e.clientX;
        o.moveNodeY = e.clientY;
        if (clssName=='ko-node') {
            o.moveNode = mouseTarget;
            o.moveNode.style.cursor = 'move';
            o.moveNode.onmousemove = nodeMove;
            o.moveNode.onmouseup = nodeMoveClose;
        }else{
            o.moveNode = mouseTarget;
            o.moveNode.style.cursor = 'move';
            o.moveNode.onmousemove = backMove;
            o.moveNode.onmouseup = nodeMoveClose;
        };
    };

    function nodeMove(e) {
        e = e || window.event;
        let offsetX = o.moveNodeX - e.clientX;
        let offsetY = o.moveNodeY - e.clientY;
        o.moveNodeX = e.clientX;
        o.moveNodeY  = e.clientY;
        o.moveNode.style.top = ( o.moveNode.offsetTop - offsetY) + "px";
        o.moveNode.style.left = ( o.moveNode.offsetLeft - offsetX) + "px";
        o.moveNode.setAttribute('x',( o.moveNode.offsetLeft - offsetX));
        o.moveNode.setAttribute('y',( o.moveNode.offsetTop - offsetY));
        reDrawNodeLines(o.moveNode);
    };

    function backMove(e) {
        e = e || window.event;
        let offsetX = o.moveNodeX - e.clientX;
        let offsetY = o.moveNodeY - e.clientY;
        o.moveNodeX = e.clientX;
        o.moveNodeY  = e.clientY;
        o.allNodes.forEach(function(nodeData,nodeId){
            let moveNode = document.getElementById(nodeId);
            moveNode.style.top = ( moveNode.offsetTop - offsetY) + "px";
            moveNode.style.left = ( moveNode.offsetLeft - offsetX) + "px";
            moveNode.setAttribute('x',( moveNode.offsetLeft - offsetX));
            moveNode.setAttribute('y',( moveNode.offsetTop - offsetY));
            reDrawNodeLines(moveNode);
        });
    };


    function nodeMove(e) {
        e = e || window.event;
        let offsetX = o.moveNodeX - e.clientX;
        let offsetY = o.moveNodeY - e.clientY;
        o.moveNodeX = e.clientX;
        o.moveNodeY  = e.clientY;
        o.moveNode.style.top = ( o.moveNode.offsetTop - offsetY) + "px";
        o.moveNode.style.left = ( o.moveNode.offsetLeft - offsetX) + "px";
        o.moveNode.setAttribute('x',( o.moveNode.offsetLeft - offsetX));
        o.moveNode.setAttribute('y',( o.moveNode.offsetTop - offsetY));
        reDrawNodeLines(o.moveNode);
    };

    function nodeMoveClose(e) {
        o.moveNode.style.cursor = 'default';
        o.moveNode.onmouseup = null;
        o.moveNode.onmousemove = null;
        o.moveNodeX = null;
        o.moveNodeY = null;
    };

    o.back.onmousemove = function (e) {
        var nx = e.clientX;
        var ny = e.clientY;
        var nl = nx - (o.moveNodeX - o.l);
        var nt = ny - (o.moveNodeY - o.t);
        if (o.isDragNode == true) {
            o.moveNode.style.left = nl + 'px';
            o.moveNode.style.top = nt + 'px';
            o.reDrawLines(o.moveNode);
        }else if (o.isDragBack==true) {
            o.allNodes.forEach(function(value,nodeKey){
                let pmoveNode = document.getElementById(nodeKey);
                let nl = nx - o.moveNodeX ;
                let nt = ny - o.moveNodeY ;
                if (nl>10) {
                    pmoveNode.style.left = Number(pmoveNode.style.left.replace('px',''))+10 + 'px';
                }else if(nl<-10){
                    pmoveNode.style.left = Number(pmoveNode.style.left.replace('px',''))-10 + 'px';
                };
                if (nt>6) {
                    pmoveNode.style.top = Number(pmoveNode.style.top.replace('px',''))+10 + 'px';
                }else if (nt<-6){
                    pmoveNode.style.top = Number(pmoveNode.style.top.replace('px',''))-10 + 'px';
                };
            });
            o.reDrawLines();
        };
    };
    o.back.onmouseup = function (e) {
        o.isDragNode = false;
        o.isDragBack = false;
        if ((o.moveNode!=undefined) && (o.moveNode.hasOwnProperty("style")==true) && (o.moveNode.style.hasOwnProperty("cursor")==true)) {
            o.moveNode.style.cursor = 'default';
        };
    };
    return o;
}