/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.handler;

import cn.langpy.kotime.annotation.Auth;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.KoUtil;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AuthHandler {
    public static Logger log = Logger.getLogger(AuthHandler.class.toString());

    @Pointcut(value="@annotation(cn.langpy.kotime.annotation.Auth)")
    public void preProcess() {
    }

    @Around(value="preProcess()")
    public Object doAroundCompute(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        boolean needAuth = method.isAnnotationPresent(Auth.class);
        if (needAuth && Context.getConfig().getAuthEnable().booleanValue()) {
            KoUtil.checkLogin();
        }
        return pjp.proceed();
    }
}

