/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.util;

import cn.langpy.kotime.model.MethodRelation;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.MethodType;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

public class Common {
    public static Logger log = Logger.getLogger(Common.class.toString());

    public static MethodType getMethodType(MethodInvocation pjp) {
        Class<?> targetClass = pjp.getThis().getClass();
        if (targetClass.getAnnotation(Controller.class) != null || targetClass.getAnnotation(RestController.class) != null) {
            return MethodType.Controller;
        }
        if (targetClass.getAnnotation(Service.class) != null) {
            return MethodType.Service;
        }
        if (targetClass.getAnnotation(Repository.class) != null) {
            return MethodType.Dao;
        }
        String className = pjp.getMethod().getDeclaringClass().getName().toLowerCase();
        if (className.contains("controller")) {
            return MethodType.Controller;
        }
        if (className.contains("service")) {
            return MethodType.Service;
        }
        if (className.contains("dao") || className.contains("mapper") || className.contains("com.sun.proxy.$Proxy")) {
            return MethodType.Dao;
        }
        return MethodType.Others;
    }

    public static MethodType getMethodType(String className) {
        if ((className = className.toLowerCase()).contains("controller")) {
            return MethodType.Controller;
        }
        if (className.contains("service")) {
            return MethodType.Service;
        }
        if (className.contains("dao") || className.contains("mapper") || className.contains("com.sun.proxy.$Proxy")) {
            return MethodType.Dao;
        }
        return MethodType.Others;
    }

    public static void showLog(String method, MethodRelation current) {
        if (Context.getConfig().getLogEnable().booleanValue() && "chinese".equals(Context.getConfig().getLogLanguage())) {
            log.info("\u8c03\u7528\u65b9\u6cd5=" + method + "\uff0c\u8017\u65f6=" + current.getAvgRunTime() + "\u6beb\u79d2");
        } else if (Context.getConfig().getLogEnable().booleanValue() && "english".equals(Context.getConfig().getLogLanguage())) {
            log.info("method=" + method + "\uff0crunTime=" + current.getAvgRunTime() + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testUrl(String httpUrl) {
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(httpUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.connect();
            urlConnection.setConnectTimeout(500);
            if (urlConnection.getResponseCode() == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (MalformedURLException e) {
            log.warning("kotime=>invalid context=" + httpUrl);
        }
        catch (IOException e) {
            log.warning("kotime=>invalid context=" + httpUrl);
        }
        finally {
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
        }
        return false;
    }
}

