/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.config;

import cn.langpy.kotime.handler.RunTimeHandler;
import cn.langpy.kotime.model.KoTimeConfig;
import cn.langpy.kotime.util.Context;
import javax.annotation.PostConstruct;
import org.aopalliance.aop.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DefaultConfig {
    @Value(value="${koTime.enable:true}")
    private Boolean kotimeEnable;
    @Value(value="${koTime.log.language:chinese}")
    private String logLanguage;
    @Value(value="${koTime.log.enable:false}")
    private Boolean logEnable;
    @Value(value="${koTime.time.threshold:800.0}")
    private Double timeThreshold;
    @Value(value="${koTime.pointcut:execution(* cn.langpy.kotime.controller.KoTimeController.*(..))}")
    private String pointcut;
    @Value(value="${koTime.exception.enable:false}")
    private Boolean exceptionEnable;
    @Value(value="${koTime.save.saver:memory}")
    private String saveSaver;
    @Value(value="${koTime.save.async:false}")
    private Boolean saveAsync;
    @Value(value="${koTime.save.thread-num:4}")
    private Integer threadNum;

    @PostConstruct
    public void function() {
        KoTimeConfig config = new KoTimeConfig();
        config.setLogEnable(this.logEnable);
        config.setLogLanguage(this.logLanguage);
        config.setTimeThreshold(this.timeThreshold);
        config.setExceptionEnable(this.exceptionEnable);
        config.setDataSaver(this.saveSaver);
        config.setKotimeEnable(this.kotimeEnable);
        Context.setConfig(config);
    }

    @Bean
    public AspectJExpressionPointcutAdvisor configurabledvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        advisor.setExpression(this.pointcut);
        advisor.setAdvice((Advice)new RunTimeHandler());
        return advisor;
    }

    public Double getTimeThreshold() {
        return this.timeThreshold;
    }

    public void setTimeThreshold(Double timeThreshold) {
        this.timeThreshold = timeThreshold;
    }

    public String getLogLanguage() {
        return this.logLanguage;
    }

    public void setLogLanguage(String logLanguage) {
        this.logLanguage = logLanguage;
    }

    public Boolean getLogEnable() {
        return this.logEnable;
    }

    public void setLogEnable(Boolean logEnable) {
        this.logEnable = logEnable;
    }
}

