/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.util;

import cn.langpy.kotime.model.RunTimeNode;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.MethodType;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

public class Common {
    public static Logger log = Logger.getLogger(Common.class.toString());

    public static StackTraceElement filter(StackTraceElement[] stacks, String packName) {
        String[] packNameSplit = packName.split("\\.");
        String filter = packNameSplit.length > 1 ? packNameSplit[0] + "." + packNameSplit[1] : packNameSplit[0];
        for (StackTraceElement stack : stacks) {
            if (!stack.getClassName().startsWith(filter) || stack.getClassName().contains("$")) continue;
            return stack;
        }
        return null;
    }

    public static MethodType getMethodType(MethodInvocation pjp) {
        Class<?> targetClass = pjp.getThis().getClass();
        if (targetClass.getAnnotation(Controller.class) != null || targetClass.getAnnotation(RestController.class) != null) {
            return MethodType.Controller;
        }
        if (targetClass.getAnnotation(Service.class) != null) {
            return MethodType.Service;
        }
        if (targetClass.getAnnotation(Repository.class) != null) {
            return MethodType.Dao;
        }
        String className = pjp.getThis().getClass().getName().toLowerCase();
        if (className.contains("controller")) {
            return MethodType.Controller;
        }
        if (className.contains("service")) {
            return MethodType.Service;
        }
        if (className.contains("dao") || className.contains("mapper") || className.contains("com.sun.proxy.$Proxy")) {
            return MethodType.Dao;
        }
        return MethodType.Others;
    }

    public static MethodType getMethodType(ProceedingJoinPoint pjp) {
        Class<?> targetClass = pjp.getTarget().getClass();
        if (targetClass.getAnnotation(Controller.class) != null || targetClass.getAnnotation(RestController.class) != null) {
            return MethodType.Controller;
        }
        if (targetClass.getAnnotation(Service.class) != null) {
            return MethodType.Service;
        }
        if (targetClass.getAnnotation(Repository.class) != null) {
            return MethodType.Dao;
        }
        String className = pjp.getTarget().getClass().getName().toLowerCase();
        if (className.contains("controller")) {
            return MethodType.Controller;
        }
        if (className.contains("service")) {
            return MethodType.Service;
        }
        if (className.contains("dao") || className.contains("mapper") || className.contains("com.sun.proxy.$Proxy")) {
            return MethodType.Dao;
        }
        return MethodType.Others;
    }

    public static MethodType getMethodType(String className) {
        if ((className = className.toLowerCase()).contains("controller")) {
            return MethodType.Controller;
        }
        if (className.contains("service")) {
            return MethodType.Service;
        }
        if (className.contains("dao") || className.contains("mapper") || className.contains("com.sun.proxy.$Proxy")) {
            return MethodType.Dao;
        }
        return MethodType.Others;
    }

    public static void showLog(RunTimeNode current) {
        String currentKey = current.getClassName() + "." + current.getMethodName();
        if (Context.getConfig().getLogEnable().booleanValue() && "chinese".equals(Context.getConfig().getLogLanguage())) {
            log.info("\u8c03\u7528\u65b9\u6cd5=" + currentKey + "\uff0c\u8017\u65f6=" + current.getAvgRunTime() + "\u6beb\u79d2");
        } else if (Context.getConfig().getLogEnable().booleanValue() && "english".equals(Context.getConfig().getLogLanguage())) {
            log.info("method=" + currentKey + "\uff0crunTime=" + current.getAvgRunTime() + "ms");
        }
    }
}

