/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.handler;

import cn.langpy.kotime.annotation.ComputeTime;
import java.util.logging.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ComputeTimeHandler {
    public static Logger log = Logger.getLogger(ComputeTimeHandler.class.toString());

    @Pointcut(value="@annotation(cn.langpy.kotime.annotation.ComputeTime)")
    public void preProcess() {
    }

    @Around(value="preProcess()")
    public Object doAroundCompute(ProceedingJoinPoint pjp) throws Throwable {
        ComputeTime computeTime = ((MethodSignature)pjp.getSignature()).getMethod().getAnnotation(ComputeTime.class);
        long begin = System.nanoTime();
        Object obj = pjp.proceed();
        long end = System.nanoTime();
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        if ("chinese".equals(computeTime.value())) {
            log.info("\u8c03\u7528\u65b9\u6cd5=" + pjp.getTarget().getClass().getName() + "." + pjp.getSignature().getName() + "\uff0c\u8017\u65f6=" + (end - begin) / 1000000L + "\u6beb\u79d2");
        } else {
            log.info("method=" + pjp.getTarget().getClass().getName() + "." + pjp.getSignature().getName() + "\uff0crunTime=" + (end - begin) / 1000000L + "\u6beb\u79d2");
        }
        return obj;
    }
}

