/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.util;

import cn.langpy.kotime.model.RunTimeNode;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.MethodType;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

public class Common {
    private static final Logger log = LoggerFactory.getLogger(Common.class);

    public static StackTraceElement filter(StackTraceElement[] stacks, String packName) {
        String[] packNameSplit = packName.split("\\.");
        String filter = packNameSplit.length > 1 ? packNameSplit[0] + "." + packNameSplit[1] : packNameSplit[0];
        for (StackTraceElement stack : stacks) {
            if (!stack.getClassName().startsWith(filter) || stack.getClassName().contains("$")) continue;
            return stack;
        }
        return null;
    }

    public static MethodType getMethodType(ProceedingJoinPoint pjp) {
        MethodType methodType = null;
        Class<?> targetClass = pjp.getTarget().getClass();
        if (targetClass.getAnnotation(Controller.class) != null || targetClass.getAnnotation(RestController.class) != null) {
            methodType = MethodType.Controller;
        } else if (targetClass.getAnnotation(Service.class) != null) {
            methodType = MethodType.Service;
        } else if (targetClass.getAnnotation(Repository.class) != null) {
            methodType = MethodType.Dao;
        }
        if (methodType == null) {
            String className = pjp.getTarget().getClass().getName().toLowerCase();
            methodType = className.contains("controller") ? MethodType.Controller : (className.contains("service") ? MethodType.Service : (className.contains("dao") || className.contains("mapper") || className.contains("com.sun.proxy.$Proxy") ? MethodType.Dao : MethodType.Others));
        }
        return methodType;
    }

    public static MethodType getMethodType(String className) {
        MethodType methodType = null;
        methodType = (className = className.toLowerCase()).contains("controller") ? MethodType.Controller : (className.contains("service") ? MethodType.Service : (className.contains("dao") || className.contains("mapper") || className.contains("com.sun.proxy.$Proxy") ? MethodType.Dao : MethodType.Others));
        return methodType;
    }

    public static void showLog(RunTimeNode current) {
        String currentKey = current.getClassName() + "." + current.getMethodName();
        if (Context.getConfig().getLogEnable().booleanValue() && "chinese".equals(Context.getConfig().getLogLanguage())) {
            log.info("\u8c03\u7528\u65b9\u6cd5=" + currentKey + "\uff0c\u8017\u65f6=" + current.getAvgRunTime() + "\u6beb\u79d2");
        } else if (Context.getConfig().getLogEnable().booleanValue() && "english".equals(Context.getConfig().getLogLanguage())) {
            log.info("method=" + currentKey + "\uff0crunTime=" + current.getAvgRunTime() + "ms");
        }
    }
}

