package cn.langpy.kotime.model;

import cn.langpy.kotime.grpc.api.RpcPhysicalMemoryInfo;

public class PhysicalMemoryInfo {
    private Long initValue;
    private Long freeValue;
    private Long usedValue;
    private Double usedRate;
    private String dataSource;

    public String getDataSource() {
        return dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }
    public Long getInitValue() {
        return initValue;
    }

    public void setInitValue(Long initValue) {
        this.initValue = initValue;
    }

    public Long getFreeValue() {
        return freeValue;
    }

    public void setFreeValue(Long freeValue) {
        this.freeValue = freeValue;
    }

    public Long getUsedValue() {
        return usedValue;
    }

    public void setUsedValue(Long usedValue) {
        this.usedValue = usedValue;
    }

    public Double getUsedRate() {
        return usedRate;
    }

    public void setUsedRate(Double usedRate) {
        this.usedRate = usedRate;
    }

    public RpcPhysicalMemoryInfo toRpc() {
        return RpcPhysicalMemoryInfo.newBuilder()
                .setInitValue(this.getInitValue())
                .setFreeValue(this.getFreeValue())
                .setUsedValue(this.getUsedValue())
                .setUsedRate(this.getUsedRate())
                .setDataSource(this.getDataSource())
                .build();
    }
}
