package cn.langpy.kotime.model;

import cn.langpy.kotime.util.MethodType;
import cn.langpy.kotime.grpc.api.RpcMethodNode;

import java.util.Objects;


public class MethodNode {
    private String id;
    private String name;
    private String className;
    private String methodName;
    private String routeName = "-";
    private Double value = 0.0;
    private MethodType methodType;
    private String dataSource;

    public String getDataSource() {
        return dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public Double getValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MethodNode that = (MethodNode) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public MethodType getMethodType() {
        return methodType;
    }

    public void setMethodType(MethodType methodType) {
        this.methodType = methodType;
    }

    public String getRouteName() {
        return routeName;
    }

    public void setRouteName(String routeName) {
        this.routeName = routeName;
    }

    @Override
    public String toString() {
        return "RunTimeNode{" +
                "id='" + id + '\'' +
                ",className='" + className + '\'' +
                ", methodName='" + methodName + '\'' +
                ", methodType=" + methodType +
                ", value=" + value +
                '}';
    }

    public RpcMethodNode toRpc() {
        return RpcMethodNode.newBuilder()
                .setId(this.getId())
                .setName(this.getName())
                .setClassName(this.getClassName())
                .setClassName(this.getClassName())
                .setMethodName(this.getMethodName())
                .setRouteName(this.getRouteName()==null?"-":this.getRouteName())
                .setValue(this.getValue())
                .setMethodType(this.getMethodType().name())
                .setDataSource(this.getDataSource())
                .build();
    }
}
