package cn.langpy.kotime.handler;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;

import java.util.concurrent.Executor;

import static io.grpc.Metadata.ASCII_STRING_MARSHALLER;

public class AuthCredential extends CallCredentials {
    private String clientName;
    private String token;

    public AuthCredential(String clientName, String token) {
        this.clientName = clientName;
        this.token = token;
    }

    @Override
    public void applyRequestMetadata(RequestInfo requestInfo, Executor executor, MetadataApplier metadataApplier) {
        String token = this.token;
        Metadata.Key<String> tokenKey = Metadata.Key.of("token", ASCII_STRING_MARSHALLER);
        Metadata.Key<String> clientKey = Metadata.Key.of("client", ASCII_STRING_MARSHALLER);
        String clientName = this.clientName;
        executor.execute(() -> {
            try {
                Metadata headers = new Metadata();

                headers.put(tokenKey, token);
                headers.put(clientKey, clientName);
                metadataApplier.apply(headers);
            } catch (Throwable e) {
                metadataApplier.fail(Status.UNAUTHENTICATED.withCause(e));
            }
        });
    }

    @Override
    public void thisUsesUnstableApi() {

    }
}
