package cn.langpy.kotime.config;

import cn.langpy.kotime.annotation.KoListener;
import cn.langpy.kotime.handler.RunTimeHandler;
import cn.langpy.kotime.service.InvokedQueue;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.handler.InvokedHandler;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.logging.Logger;

/**
 * zhangchang
 */
@ComponentScan("cn.langpy.kotime")
@Configuration
public class LoadConfig {
    private static Logger log = Logger.getLogger(LoadConfig.class.toString());

    @Value("${server.servlet.context-path:}")
    private String serverContext;

    @Resource
    private DefaultConfig defaultConfig;
    @Resource
    private ApplicationContext applicationContext;


    @PostConstruct
    public void initConfig() {
        DefaultConfig config = new DefaultConfig();
        config.setLogEnable(defaultConfig.getLogEnable() == null ? false : defaultConfig.getLogEnable());
        config.setLogLanguage(defaultConfig.getLogLanguage() == null ? "chinese" : defaultConfig.getLogLanguage());
        config.setThreshold(defaultConfig.getThreshold() == null ? 800.0 : defaultConfig.getThreshold());
        config.setExceptionEnable(defaultConfig.getExceptionEnable() == null ? false : defaultConfig.getExceptionEnable());
        config.setEnable(defaultConfig.getEnable() == null ? true : defaultConfig.getEnable());
        config.setDataPrefix(defaultConfig.getDataPrefix() == null ? (StringUtils.hasText(serverContext)?serverContext.substring(1):"KOTIME") : defaultConfig.getDataPrefix());
        config.setLanguage(defaultConfig.getLanguage() == null ? "chinese" : defaultConfig.getLanguage());
        config.setThreadNum(defaultConfig.getThreadNum() == null ? 2 : defaultConfig.getThreadNum());
        config.setAuthEnable(defaultConfig.getAuthEnable() == null ? false : defaultConfig.getAuthEnable());
        config.setParamAnalyse(defaultConfig.getParamAnalyse() == null ? true : defaultConfig.getParamAnalyse());
        config.setDebug(defaultConfig.getDebug() == null ? false : defaultConfig.getDebug());
        Context.setConfig(config);
        log.info("kotime=>loading config");

        initMethodHandlers();
    }


    public void initMethodHandlers() {
        String[] names = applicationContext.getBeanNamesForType(InvokedHandler.class);
        for (String name : names) {
            InvokedHandler bean = (InvokedHandler) applicationContext.getBean(name);
            if (null != bean) {
                KoListener annotation = bean.getClass().getAnnotation(KoListener.class);
                if (null == annotation) {
                    continue;
                }
                log.info("kotime=>loading InvokedHandler:" + bean.getClass().getSimpleName());
                Context.addInvokedHandler(bean);
            }
        }
        for (int i = 0; i < Context.getConfig().getThreadNum(); i++) {
            new Thread(() -> InvokedQueue.onInveked()).start();
        }
    }

    @Bean
    public AspectJExpressionPointcutAdvisor configurabledvisor() {
        log.info("kotime=>loading method listener");
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        String cutRange = defaultConfig.getPointcut();
        if (!StringUtils.hasText(cutRange)) {
            throw new RuntimeException("No 'ko-time.pointcut found,please set it.'");
        }
        cutRange = cutRange + " && !@annotation(cn.langpy.kotime.annotation.KoListener)";
        advisor.setExpression(cutRange);
        advisor.setAdvice(new RunTimeHandler());
        return advisor;
    }
}
