/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.AfterFilter;
import com.alibaba.fastjson2.filter.BeanContext;
import com.alibaba.fastjson2.filter.BeforeFilter;
import com.alibaba.fastjson2.filter.ContextNameFilter;
import com.alibaba.fastjson2.filter.ContextValueFilter;
import com.alibaba.fastjson2.filter.LabelFilter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplCollection;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ObjectWriterAdapter<T>
implements ObjectWriter<T> {
    PropertyPreFilter propertyPreFilter;
    PropertyFilter propertyFilter;
    NameFilter nameFilter;
    ValueFilter valueFilter;
    static final String TYPE = "@type";
    final Class objectType;
    final List<FieldWriter> fieldWriters;
    protected final FieldWriter[] fieldWriterArray;
    final String typeKey;
    byte[] typeKeyJSONB;
    protected final String typeName;
    protected final long typeNameHash;
    protected byte[] typeNameJSONB;
    byte[] nameWithColonUTF8;
    char[] nameWithColonUTF16;
    final long features;
    final long[] hashCodes;
    final short[] mapping;
    final boolean hasValueField;
    final boolean serializable;
    byte[] jsonbClassInfo;

    public ObjectWriterAdapter(Class<T> objectType, List<FieldWriter> fieldWriters) {
        this(objectType, null, null, 0L, fieldWriters);
    }

    public ObjectWriterAdapter(Class<T> objectType, String typeKey, String typeName, long features, List<FieldWriter> fieldWriters) {
        int i;
        if (typeName == null && objectType != null) {
            typeName = Enum.class.isAssignableFrom(objectType) && !objectType.isEnum() ? objectType.getSuperclass().getName() : TypeUtils.getTypeName(objectType);
        }
        this.objectType = objectType;
        this.typeKey = typeKey == null || typeKey.isEmpty() ? TYPE : typeKey;
        this.typeName = typeName;
        this.typeNameHash = typeName != null ? Fnv.hashCode64(typeName) : 0L;
        this.features = features;
        this.fieldWriters = fieldWriters;
        this.serializable = Serializable.class.isAssignableFrom(objectType);
        this.fieldWriterArray = new FieldWriter[fieldWriters.size()];
        fieldWriters.toArray(this.fieldWriterArray);
        this.hasValueField = this.fieldWriterArray.length == 1 && (this.fieldWriterArray[0].getFeatures() & 0x1000000000000L) != 0L;
        long[] hashCodes = new long[this.fieldWriterArray.length];
        for (i = 0; i < this.fieldWriterArray.length; ++i) {
            long hashCode;
            FieldWriter item = this.fieldWriterArray[i];
            hashCodes[i] = hashCode = Fnv.hashCode64(item.getFieldName());
        }
        this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
        Arrays.sort(this.hashCodes);
        this.mapping = new short[this.hashCodes.length];
        for (i = 0; i < hashCodes.length; ++i) {
            long hashCode = hashCodes[i];
            int index = Arrays.binarySearch(this.hashCodes, hashCode);
            this.mapping[index] = (short)i;
        }
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    public ObjectWriterAdapter(Class<T> objectType, long features, FieldWriter ... fieldWriters) {
        int i;
        this.objectType = objectType;
        this.typeKey = TYPE;
        this.fieldWriters = Arrays.asList(fieldWriters);
        this.fieldWriterArray = fieldWriters;
        this.features = features;
        this.hasValueField = this.fieldWriterArray.length == 1 && (this.fieldWriterArray[0].getFeatures() & 0x1000000000000L) != 0L;
        this.serializable = objectType == null || Serializable.class.isAssignableFrom(objectType);
        String typeName = null;
        if (objectType != null) {
            typeName = Enum.class.isAssignableFrom(objectType) && !objectType.isEnum() ? objectType.getSuperclass().getName() : TypeUtils.getTypeName(objectType);
        }
        this.typeName = typeName;
        this.typeNameHash = typeName != null ? Fnv.hashCode64(typeName) : 0L;
        long[] hashCodes = new long[this.fieldWriterArray.length];
        for (i = 0; i < this.fieldWriterArray.length; ++i) {
            long hashCode;
            FieldWriter item = this.fieldWriterArray[i];
            hashCodes[i] = hashCode = Fnv.hashCode64(item.getFieldName());
        }
        this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
        Arrays.sort(this.hashCodes);
        this.mapping = new short[this.hashCodes.length];
        for (i = 0; i < hashCodes.length; ++i) {
            long hashCode = hashCodes[i];
            int index = Arrays.binarySearch(this.hashCodes, hashCode);
            this.mapping[index] = (short)i;
        }
    }

    @Override
    public FieldWriter getFieldWriter(long hashCode) {
        int m3 = Arrays.binarySearch(this.hashCodes, hashCode);
        if (m3 < 0) {
            return null;
        }
        short index = this.mapping[m3];
        return this.fieldWriterArray[index];
    }

    @Override
    public boolean hasFilter(JSONWriter jsonWriter) {
        return this.propertyPreFilter != null || this.propertyFilter != null || this.nameFilter != null || this.valueFilter != null || jsonWriter.hasFilter();
    }

    public void setPropertyFilter(PropertyFilter propertyFilter) {
        this.propertyFilter = propertyFilter;
    }

    public void setValueFilter(ValueFilter valueFilter) {
        this.valueFilter = valueFilter;
    }

    public void setNameFilter(NameFilter nameFilter) {
        this.nameFilter = nameFilter;
    }

    public void setPropertyPreFilter(PropertyPreFilter propertyPreFilter) {
        this.propertyPreFilter = propertyPreFilter;
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        long featuresAll = features | this.features | jsonWriter.getFeatures();
        if (!this.serializable) {
            if ((featuresAll & JSONWriter.Feature.ErrorOnNoneSerializable.mask) != 0L) {
                this.errorOnNoneSerializable();
                return;
            }
            if ((featuresAll & JSONWriter.Feature.IgnoreNoneSerializable.mask) != 0L) {
                jsonWriter.writeNull();
                return;
            }
        }
        int size = this.fieldWriterArray.length;
        if (jsonWriter.isWriteTypeInfo(object, fieldType, features)) {
            this.writeClassInfo(jsonWriter);
        }
        jsonWriter.startObject();
        for (int i = 0; i < size; ++i) {
            FieldWriter fieldWriter = this.fieldWriters.get(i);
            fieldWriter.write(jsonWriter, object);
        }
        jsonWriter.endObject();
    }

    protected void writeClassInfo(JSONWriter jsonWriter) {
        if (this.typeNameJSONB == null) {
            this.typeNameJSONB = JSONB.toBytes(this.typeName);
        }
        jsonWriter.writeTypeName(this.typeNameJSONB, this.typeNameHash);
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        long featuresAll;
        if (this.hasValueField) {
            FieldWriter fieldWriter = this.fieldWriterArray[0];
            fieldWriter.writeValue(jsonWriter, object);
            return;
        }
        if (jsonWriter.isJSONB()) {
            if (jsonWriter.isBeanToArray()) {
                this.writeArrayMappingJSONB(jsonWriter, object, fieldName, fieldType, features);
                return;
            }
            this.writeJSONB(jsonWriter, object, fieldName, fieldType, features);
            return;
        }
        if (this.typeName != null) {
            switch (this.typeName) {
                case "com.google.common.collect.AbstractMapBasedMultimap$RandomAccessWrappedList": 
                case "com.google.common.collect.AbstractMapBasedMultimap$WrappedSet": {
                    Collection collection = (Collection)object;
                    ObjectWriterImplCollection.INSTANCE.write(jsonWriter, collection, fieldName, fieldType, features);
                    return;
                }
            }
        }
        if (((featuresAll = features | this.features | jsonWriter.getFeatures()) & JSONWriter.Feature.BeanToArray.mask) != 0L) {
            this.writeArrayMapping(jsonWriter, object, fieldName, fieldType, features | this.features);
            return;
        }
        if (!this.serializable) {
            if ((featuresAll & JSONWriter.Feature.ErrorOnNoneSerializable.mask) != 0L) {
                this.errorOnNoneSerializable();
                return;
            }
            if ((featuresAll & JSONWriter.Feature.IgnoreNoneSerializable.mask) != 0L) {
                jsonWriter.writeNull();
                return;
            }
        }
        if (this.hasFilter(jsonWriter)) {
            this.writeWithFilter(jsonWriter, object, fieldName, fieldType, 0L);
            return;
        }
        jsonWriter.startObject();
        if (((features | this.features) & JSONWriter.Feature.WriteClassName.mask) != 0L || jsonWriter.isWriteTypeInfo(object, features)) {
            this.writeTypeInfo(jsonWriter);
        }
        int size = this.fieldWriters.size();
        for (int i = 0; i < size; ++i) {
            FieldWriter fieldWriter = this.fieldWriters.get(i);
            fieldWriter.write(jsonWriter, object);
        }
        jsonWriter.endObject();
    }

    public Map<String, Object> toMap(Object object) {
        JSONObject map = new JSONObject(this.fieldWriters.size());
        for (int i = 0; i < this.fieldWriters.size(); ++i) {
            FieldWriter fieldWriter = this.fieldWriters.get(i);
            map.put(fieldWriter.getFieldName(), fieldWriter.getFieldValue(object));
        }
        return map;
    }

    @Override
    public List<FieldWriter> getFieldWriters() {
        return this.fieldWriters;
    }

    @Override
    public boolean writeTypeInfo(JSONWriter jsonWriter) {
        if (jsonWriter.isUTF8()) {
            if (this.nameWithColonUTF8 == null) {
                byte[] chars = new byte[this.typeKey.length() + this.typeName.length() + 5];
                chars[0] = 34;
                this.typeKey.getBytes(0, this.typeKey.length(), chars, 1);
                chars[this.typeKey.length() + 1] = 34;
                chars[this.typeKey.length() + 2] = 58;
                chars[this.typeKey.length() + 3] = 34;
                this.typeName.getBytes(0, this.typeName.length(), chars, this.typeKey.length() + 4);
                chars[this.typeKey.length() + this.typeName.length() + 4] = 34;
                this.nameWithColonUTF8 = chars;
            }
            jsonWriter.writeNameRaw(this.nameWithColonUTF8);
            return true;
        }
        if (jsonWriter.isUTF16()) {
            if (this.nameWithColonUTF16 == null) {
                char[] chars = new char[this.typeKey.length() + this.typeName.length() + 5];
                chars[0] = 34;
                this.typeKey.getChars(0, this.typeKey.length(), chars, 1);
                chars[this.typeKey.length() + 1] = 34;
                chars[this.typeKey.length() + 2] = 58;
                chars[this.typeKey.length() + 3] = 34;
                this.typeName.getChars(0, this.typeName.length(), chars, this.typeKey.length() + 4);
                chars[this.typeKey.length() + this.typeName.length() + 4] = 34;
                this.nameWithColonUTF16 = chars;
            }
            jsonWriter.writeNameRaw(this.nameWithColonUTF16);
            return true;
        }
        if (jsonWriter.isJSONB()) {
            if (this.typeNameJSONB == null) {
                this.typeNameJSONB = JSONB.toBytes(this.typeName);
            }
            if (this.typeKeyJSONB == null) {
                this.typeKeyJSONB = JSONB.toBytes(this.typeKey);
            }
            jsonWriter.writeRaw(this.typeKeyJSONB);
            jsonWriter.writeRaw(this.typeNameJSONB);
            return true;
        }
        jsonWriter.writeString(this.typeKey);
        jsonWriter.writeColon();
        jsonWriter.writeString(this.typeName);
        return true;
    }

    @Override
    public void writeWithFilter(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        JSONWriter.Context context;
        BeforeFilter beforeFilter;
        jsonWriter.startObject();
        if (jsonWriter.isWriteTypeInfo(object, features)) {
            this.writeTypeInfo(jsonWriter);
        }
        if ((beforeFilter = (context = jsonWriter.getContext()).getBeforeFilter()) != null) {
            beforeFilter.writeBefore(jsonWriter, object);
        }
        PropertyPreFilter propertyPreFilter = context.getPropertyPreFilter();
        NameFilter nameFilter = context.getNameFilter();
        ContextNameFilter contextNameFilter = context.getContextNameFilter();
        ValueFilter valueFilter = context.getValueFilter();
        ContextValueFilter contextValueFilter = context.getContextValueFilter();
        PropertyFilter propertyFilter = context.getPropertyFilter();
        LabelFilter labelFilter = context.getLabelFilter();
        List<FieldWriter> fieldWriters = this.getFieldWriters();
        int size = fieldWriters.size();
        for (int i = 0; i < size; ++i) {
            ObjectWriter fieldValueWriter;
            String label;
            FieldWriter fieldWriter = fieldWriters.get(i);
            String fieldWriterFieldName = fieldWriter.getFieldName();
            if (propertyPreFilter != null && !propertyPreFilter.process(jsonWriter, object, fieldWriterFieldName) || labelFilter != null && (label = fieldWriter.getLabel()) != null && !label.isEmpty() && !labelFilter.apply(label)) continue;
            if (nameFilter == null && propertyFilter == null && valueFilter == null && contextValueFilter == null && contextNameFilter == null) {
                fieldWriter.write(jsonWriter, object);
                continue;
            }
            Object fieldValue = fieldWriter.getFieldValue(object);
            if (fieldValue == null && !jsonWriter.isWriteNulls()) continue;
            BeanContext beanContext = null;
            String filteredName = fieldWriterFieldName;
            if (nameFilter != null) {
                filteredName = nameFilter.process(object, filteredName, fieldValue);
            }
            if (contextNameFilter != null) {
                beanContext = new BeanContext(this.objectType, fieldWriter.getMethod(), fieldWriter.getField(), fieldWriter.getFieldName(), fieldWriter.getLabel(), fieldWriter.getFieldClass(), fieldWriter.getFieldType(), fieldWriter.getFeatures(), fieldWriter.getFormat());
                filteredName = contextNameFilter.process(beanContext, object, filteredName, fieldValue);
            }
            if (propertyFilter != null && !propertyFilter.apply(object, fieldWriterFieldName, fieldValue)) continue;
            boolean nameChanged = filteredName != null && filteredName != fieldWriterFieldName;
            Object filteredValue = fieldValue;
            if (valueFilter != null) {
                filteredValue = valueFilter.apply(object, fieldWriterFieldName, fieldValue);
            }
            if (contextValueFilter != null) {
                if (beanContext == null) {
                    beanContext = new BeanContext(this.objectType, fieldWriter.getMethod(), fieldWriter.getField(), fieldWriter.getFieldName(), fieldWriter.getLabel(), fieldWriter.getFieldClass(), fieldWriter.getFieldType(), fieldWriter.getFeatures(), fieldWriter.getFormat());
                }
                filteredValue = contextValueFilter.process(beanContext, object, filteredName, filteredValue);
            }
            if (filteredValue != fieldValue) {
                if (nameChanged) {
                    jsonWriter.writeName(filteredName);
                    jsonWriter.writeColon();
                } else {
                    fieldWriter.writeFieldName(jsonWriter);
                }
                if (filteredValue == null) {
                    jsonWriter.writeNull();
                    continue;
                }
                fieldValueWriter = fieldWriter.getObjectWriter(jsonWriter, filteredValue.getClass());
                fieldValueWriter.write(jsonWriter, filteredValue, fieldName, fieldType, features);
                continue;
            }
            if (!nameChanged) {
                fieldWriter.write(jsonWriter, object);
                continue;
            }
            if (nameChanged) {
                jsonWriter.writeName(filteredName);
                jsonWriter.writeColon();
            } else {
                fieldWriter.writeFieldName(jsonWriter);
            }
            if (fieldValue == null) {
                fieldValueWriter = fieldWriter.getObjectWriter(jsonWriter, fieldWriter.getFieldClass());
                fieldValueWriter.write(jsonWriter, null, fieldName, fieldType, features);
                continue;
            }
            fieldValueWriter = fieldWriter.getObjectWriter(jsonWriter, fieldValue.getClass());
            fieldValueWriter.write(jsonWriter, fieldValue, fieldName, fieldType, features);
        }
        AfterFilter afterFilter = context.getAfterFilter();
        if (afterFilter != null) {
            afterFilter.writeAfter(jsonWriter, object);
        }
        jsonWriter.endObject();
    }

    public JSONObject toJSONObject(T object) {
        JSONObject jsonObject = new JSONObject();
        for (FieldWriter fieldWriter : this.fieldWriters) {
            Object fieldValue = fieldWriter.getFieldValue(object);
            long fieldFeatures = fieldWriter.getFeatures();
            if ((fieldFeatures & 0x2000000000000L) != 0L) {
                if (fieldValue instanceof Map) {
                    jsonObject.putAll((Map)fieldValue);
                    continue;
                }
                ObjectWriter fieldObjectWriter = fieldWriter.getInitWriter();
                if (fieldObjectWriter == null) {
                    fieldObjectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(fieldWriter.getFieldClass());
                }
                List<FieldWriter> unwrappedFieldWriters = fieldObjectWriter.getFieldWriters();
                for (FieldWriter unwrappedFieldWriter : unwrappedFieldWriters) {
                    Object unwrappedFieldValue = unwrappedFieldWriter.getFieldValue(fieldValue);
                    jsonObject.put(unwrappedFieldWriter.getFieldName(), unwrappedFieldValue);
                }
                continue;
            }
            jsonObject.put(fieldWriter.getFieldName(), fieldValue);
        }
        return jsonObject;
    }

    public String toString() {
        return this.objectType.getName();
    }

    protected void errorOnNoneSerializable() {
        throw new JSONException("not support none serializable class " + this.objectType.getName());
    }
}

