/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum;
import com.alibaba.fastjson2.reader.ObjectReaderImplInstant;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.JSONObject1O;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;

public class TypeUtils {
    public static final Class CLASS_SINGLE_SET;
    static final int ENUM = 16384;
    static final Cache CACHE;
    static final AtomicReferenceFieldUpdater<Cache, char[]> CHARS_UPDATER;
    static final Map<Class, String> NAME_MAPPINGS;
    static final Map<String, Class> TYPE_MAPPINGS;

    public static Class<?> getMapping(Type type) {
        Type[] upperBounds;
        if (type == null) {
            return null;
        }
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getMapping(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            Type boundType = ((TypeVariable)type).getBounds()[0];
            if (boundType instanceof Class) {
                return (Class)boundType;
            }
            return TypeUtils.getMapping(boundType);
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return TypeUtils.getMapping(upperBounds[0]);
        }
        return Object.class;
    }

    public static Date toDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Instant) {
            Instant instant = (Instant)obj;
            return new Date(instant.toEpochMilli());
        }
        if (obj instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)obj;
            return new Date(zdt.toInstant().toEpochMilli());
        }
        if (obj instanceof LocalDate) {
            LocalDate localDate = (LocalDate)obj;
            ZonedDateTime zdt = localDate.atStartOfDay(ZoneId.systemDefault());
            return new Date(zdt.toInstant().toEpochMilli());
        }
        if (obj instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)obj;
            ZonedDateTime zdt = ldt.atZone(ZoneId.systemDefault());
            return new Date(zdt.toInstant().toEpochMilli());
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            JSONReader jsonReader = str.charAt(0) != '\"' ? JSONReader.of('\"' + str + '\"') : JSONReader.of(str);
            return jsonReader.read(Date.class);
        }
        if (obj instanceof Long) {
            return new Date((Long)obj);
        }
        throw new JSONException("can not cast to Date from " + obj.getClass());
    }

    public static Instant toInstant(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Instant) {
            return (Instant)obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).toInstant();
        }
        if (obj instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)obj;
            return zdt.toInstant();
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            JSONReader jsonReader = str.charAt(0) != '\"' ? JSONReader.of('\"' + str + '\"') : JSONReader.of(str);
            return jsonReader.read(Instant.class);
        }
        if (obj instanceof Map) {
            return (Instant)ObjectReaderImplInstant.INSTANCE.createInstance((Map)obj, 0L);
        }
        throw new JSONException("can not cast to Date from " + obj.getClass());
    }

    public static <T> T cast(Object obj, Class<T> targetClass) {
        if (obj == null) {
            return null;
        }
        if (targetClass.isInstance(obj)) {
            return (T)obj;
        }
        if (targetClass == Date.class) {
            return (T)TypeUtils.toDate(obj);
        }
        if (targetClass == Instant.class) {
            return (T)TypeUtils.toInstant(obj);
        }
        if (targetClass == String.class) {
            return (T)JSON.toJSONString(obj);
        }
        if (targetClass == AtomicInteger.class) {
            return (T)new AtomicInteger(TypeUtils.toIntValue(obj));
        }
        if (targetClass == AtomicLong.class) {
            return (T)new AtomicLong(TypeUtils.toLongValue(obj));
        }
        if (targetClass == AtomicBoolean.class) {
            return (T)new AtomicBoolean((Boolean)obj);
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        if (obj instanceof Map) {
            ObjectReader objectReader = provider.getObjectReader(targetClass);
            return objectReader.createInstance((Map)obj, 0L);
        }
        Function typeConvert = provider.getTypeConvert(obj.getClass(), targetClass);
        if (typeConvert != null) {
            return (T)typeConvert.apply(obj);
        }
        if (obj instanceof String) {
            String json = (String)obj;
            if (json.isEmpty() || "null".equals(json)) {
                return null;
            }
            char first = json.trim().charAt(0);
            JSONReader jsonReader = first == '\"' || first == '{' || first == '[' ? JSONReader.of(json) : JSONReader.of(JSON.toJSONString(json));
            ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(targetClass);
            return objectReader.readObject(jsonReader, null, null, 0L);
        }
        if (targetClass.isEnum() && obj instanceof Integer) {
            int ordinal = (Integer)obj;
            ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(targetClass);
            if (objectReader instanceof ObjectReaderImplEnum) {
                Enum e = ((ObjectReaderImplEnum)objectReader).getEnumByOrdinal(ordinal);
                return (T)e;
            }
        }
        throw new JSONException("can not cast to " + targetClass.getName() + ", from " + obj.getClass());
    }

    public static String getTypeName(Class type) {
        String typeName;
        Class<?>[] interfaces;
        String mapTypeName = NAME_MAPPINGS.get(type);
        if (mapTypeName != null) {
            return mapTypeName;
        }
        if (Proxy.isProxyClass(type) && (interfaces = type.getInterfaces()).length > 0) {
            type = interfaces[0];
        }
        switch (typeName = type.getTypeName()) {
            case "com.alibaba.fastjson.JSONObject": {
                NAME_MAPPINGS.putIfAbsent(type, "JO1");
                return NAME_MAPPINGS.get(type);
            }
            case "com.alibaba.fastjson.JSONArray": {
                NAME_MAPPINGS.putIfAbsent(type, "JA1");
                return NAME_MAPPINGS.get(type);
            }
        }
        return typeName;
    }

    public static Class getMapping(String typeName) {
        return TYPE_MAPPINGS.get(typeName);
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (value == null || value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return BigDecimal.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return new BigDecimal(str);
        }
        throw new JSONException("can not cast to decimal from " + value.getClass());
    }

    public static BigInteger toBigInteger(Object value) {
        if (value == null || value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return new BigInteger(str);
        }
        throw new JSONException("can not cast to bigint");
    }

    public static Long toLong(Object value) {
        if (value == null || value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("can not cast to long, class " + value.getClass());
    }

    public static long toLongValue(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0L;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("can not cast to long");
    }

    public static Integer toInteger(Object value) {
        if (value == null || value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Integer.parseInt(str);
        }
        if (value instanceof Map && ((Map)value).isEmpty()) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new JSONException("can not cast to integer");
    }

    public static Byte toByte(Object value) {
        if (value == null || value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static byte toByteValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static Short toShort(Object value) {
        if (value == null || value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static short toShortValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return (byte)((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("can not cast to byte");
    }

    public static int toIntValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0;
            }
            if (str.indexOf(46) != -1) {
                return new BigDecimal(str).intValueExact();
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static boolean toBooleanValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return false;
            }
            return Boolean.parseBoolean(str);
        }
        if (value instanceof Number) {
            int intValue = ((Number)value).intValue();
            if (intValue == 1) {
                return true;
            }
            if (intValue == 0) {
                return false;
            }
        }
        throw new JSONException("can not cast to boolean");
    }

    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Boolean.parseBoolean(str);
        }
        if (value instanceof Number) {
            int intValue = ((Number)value).intValue();
            if (intValue == 1) {
                return true;
            }
            if (intValue == 0) {
                return false;
            }
        }
        throw new JSONException("can not cast to boolean");
    }

    public static float toFloatValue(Object value) {
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static Float toFloat(Object value) {
        if (value == null || value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(str));
        }
        throw new JSONException("can not cast to decimal");
    }

    public static double toDoubleValue(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return 0.0;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static Double toDouble(Object value) {
        if (value == null || value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("can not cast to decimal");
    }

    public static int compare(Object a, Object b) {
        if (a.getClass() == b.getClass()) {
            return ((Comparable)a).compareTo(b);
        }
        Class<?> typeA = a.getClass();
        Class<?> typeB = b.getClass();
        if (typeA == BigDecimal.class) {
            if (typeB == Integer.class) {
                b = new BigDecimal((Integer)b);
            } else if (typeB == Long.class) {
                b = new BigDecimal((Long)b);
            } else if (typeB == Float.class) {
                b = new BigDecimal(((Float)b).floatValue());
            } else if (typeB == Double.class) {
                b = new BigDecimal((Double)b);
            } else if (typeB == BigInteger.class) {
                b = new BigDecimal((BigInteger)b);
            }
        } else if (typeA == BigInteger.class) {
            if (typeB == Integer.class) {
                b = BigInteger.valueOf(((Integer)b).intValue());
            } else if (typeB == Long.class) {
                b = BigInteger.valueOf((Long)b);
            } else if (typeB == Float.class) {
                b = new BigDecimal(((Float)b).floatValue());
                a = new BigDecimal((BigInteger)a);
            } else if (typeB == Double.class) {
                b = new BigDecimal((Double)b);
                a = new BigDecimal((BigInteger)a);
            } else if (typeB == BigDecimal.class) {
                a = new BigDecimal((BigInteger)a);
            }
        } else if (typeA == Long.class) {
            if (typeB == Integer.class) {
                b = new Long(((Integer)b).intValue());
            } else if (typeB == BigDecimal.class) {
                a = new BigDecimal((Long)a);
            } else if (typeB == Float.class) {
                a = new Float(((Long)a).longValue());
            } else if (typeB == Double.class) {
                a = new Double(((Long)a).longValue());
            } else if (typeB == BigInteger.class) {
                a = BigInteger.valueOf((Long)a);
            } else if (typeB == String.class) {
                a = BigDecimal.valueOf((Long)a);
                b = new BigDecimal((String)b);
            }
        } else if (typeA == Integer.class) {
            if (typeB == Long.class) {
                a = new Long(((Integer)a).intValue());
            } else if (typeB == BigDecimal.class) {
                a = new BigDecimal((Integer)a);
            } else if (typeB == BigInteger.class) {
                a = BigInteger.valueOf(((Integer)a).intValue());
            } else if (typeB == Float.class) {
                a = new Float(((Integer)a).intValue());
            } else if (typeB == Double.class) {
                a = new Double(((Integer)a).intValue());
            } else if (typeB == String.class) {
                a = BigDecimal.valueOf(((Integer)a).intValue());
                b = new BigDecimal((String)b);
            }
        } else if (typeA == Double.class) {
            if (typeB == Integer.class) {
                b = new Double(((Integer)b).intValue());
            } else if (typeB == Long.class) {
                b = new Double(((Long)b).longValue());
            } else if (typeB == Float.class) {
                b = new Double(((Float)b).floatValue());
            } else if (typeB == BigDecimal.class) {
                a = BigDecimal.valueOf((Double)a);
            } else if (typeB == String.class) {
                a = BigDecimal.valueOf((Double)a);
                b = new BigDecimal((String)b);
            } else if (typeB == BigInteger.class) {
                a = BigDecimal.valueOf((Double)a);
                b = new BigDecimal((BigInteger)b);
            }
        } else if (typeA == Float.class) {
            if (typeB == Integer.class) {
                b = new Float(((Integer)b).intValue());
            } else if (typeB == Long.class) {
                b = new Float(((Long)b).longValue());
            } else if (typeB == Double.class) {
                a = new Double(((Float)a).floatValue());
            } else if (typeB == BigDecimal.class) {
                a = BigDecimal.valueOf(((Float)a).floatValue());
            } else if (typeB == String.class) {
                a = BigDecimal.valueOf(((Float)a).floatValue());
                b = new BigDecimal((String)b);
            } else if (typeB == BigInteger.class) {
                a = BigDecimal.valueOf(((Float)a).floatValue());
                b = new BigDecimal((BigInteger)b);
            }
        } else if (typeA == String.class) {
            String strA = (String)a;
            if (typeB == Integer.class) {
                NumberFormatException error = null;
                try {
                    a = Integer.parseInt(strA);
                }
                catch (NumberFormatException ex) {
                    error = ex;
                }
                if (error != null) {
                    try {
                        a = Long.parseLong(strA);
                        b = (long)((Integer)b).intValue();
                        error = null;
                    }
                    catch (NumberFormatException ex) {
                        error = ex;
                    }
                }
                if (error != null) {
                    a = new BigDecimal(strA);
                    b = BigDecimal.valueOf(((Integer)b).intValue());
                }
            } else if (typeB == Long.class) {
                a = new BigDecimal(strA);
                b = BigDecimal.valueOf((Long)b);
            } else if (typeB == Float.class) {
                a = Float.valueOf(Float.parseFloat(strA));
            } else if (typeB == Double.class) {
                a = Double.parseDouble(strA);
            } else if (typeB == BigInteger.class) {
                a = new BigInteger(strA);
            } else if (typeB == BigDecimal.class) {
                a = new BigDecimal(strA);
            }
        }
        return ((Comparable)a).compareTo(b);
    }

    public static Object getDefaultValue(Type paramType) {
        if (paramType == Integer.TYPE) {
            return 0;
        }
        if (paramType == Long.TYPE) {
            return 0L;
        }
        if (paramType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (paramType == Double.TYPE) {
            return 0.0;
        }
        if (paramType == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (paramType == Short.TYPE) {
            return (short)0;
        }
        if (paramType == Byte.TYPE) {
            return (byte)0;
        }
        if (paramType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (paramType == Optional.class) {
            return Optional.empty();
        }
        if (paramType == OptionalInt.class) {
            return OptionalInt.empty();
        }
        if (paramType == OptionalLong.class) {
            return OptionalLong.empty();
        }
        if (paramType == OptionalDouble.class) {
            return OptionalDouble.empty();
        }
        return null;
    }

    public static Class loadClass(String className) {
        if (className.length() >= 192) {
            return null;
        }
        switch (className) {
            case "java.lang.Object": {
                return Object.class;
            }
            case "class java.util.Collections$EmptyMap": {
                return Collections.EMPTY_MAP.getClass();
            }
            case "java.util.Collections$EmptyList": {
                return Collections.EMPTY_LIST.getClass();
            }
            case "java.util.Collections$EmptySet": {
                return Collections.EMPTY_SET.getClass();
            }
            case "java.util.Optional": {
                return Optional.class;
            }
            case "java.util.OptionalInt": {
                return OptionalInt.class;
            }
            case "java.util.OptionalLong": {
                return OptionalLong.class;
            }
            case "java.util.List": {
                return List.class;
            }
            case "java.util.ArrayList": {
                return ArrayList.class;
            }
            case "java.util.Map": {
                return Map.class;
            }
            case "java.util.HashMap": {
                return HashMap.class;
            }
            case "java.lang.Class": {
                return Class.class;
            }
            case "java.lang.Integer": {
                return Integer.class;
            }
            case "java.lang.Long": {
                return Long.class;
            }
            case "java.lang.String": {
                return String.class;
            }
            case "I": 
            case "int": {
                return Integer.TYPE;
            }
            case "S": 
            case "short": {
                return Short.TYPE;
            }
            case "J": 
            case "long": {
                return Long.TYPE;
            }
            case "Z": 
            case "boolean": {
                return Boolean.TYPE;
            }
            case "B": 
            case "byte": {
                return Byte.TYPE;
            }
            case "F": 
            case "float": {
                return Float.TYPE;
            }
            case "D": 
            case "double": {
                return Double.TYPE;
            }
            case "C": 
            case "char": {
                return Character.TYPE;
            }
            case "[B": 
            case "byte[]": {
                return byte[].class;
            }
            case "[S": 
            case "short[]": {
                return short[].class;
            }
            case "[I": 
            case "int[]": {
                return int[].class;
            }
            case "[J": 
            case "long[]": {
                return long[].class;
            }
            case "[F": 
            case "float[]": {
                return float[].class;
            }
            case "[D": 
            case "double[]": {
                return double[].class;
            }
            case "[C": 
            case "char[]": {
                return char[].class;
            }
            case "[Z": 
            case "boolean[]": {
                return boolean[].class;
            }
            case "java.io.IOException": {
                return IOException.class;
            }
        }
        if (className.charAt(0) == '[' || className.endsWith("[]")) {
            String itemClassName = className.charAt(0) == '[' ? className.substring(1) : className.substring(0, className.length() - 2);
            Class itemClass = TypeUtils.loadClass(itemClassName);
            if (itemClass == null) {
                throw new JSONException("load class error " + className);
            }
            return Array.newInstance(itemClass, 0).getClass();
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return JSON.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }

    public static Class<?> getClass(Type type) {
        Type[] upperBounds;
        if (type == null) {
            return null;
        }
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            Type boundType = ((TypeVariable)type).getBounds()[0];
            if (boundType instanceof Class) {
                return (Class)boundType;
            }
            return TypeUtils.getClass(boundType);
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return TypeUtils.getClass(upperBounds[0]);
        }
        return Object.class;
    }

    public static boolean isProxy(Class<?> clazz) {
        for (Class<?> item : clazz.getInterfaces()) {
            String interfaceName;
            switch (interfaceName = item.getName()) {
                case "org.springframework.cglib.proxy.Factory": 
                case "javassist.util.proxy.ProxyObject": 
                case "org.apache.ibatis.javassist.util.proxy.ProxyObject": 
                case "org.hibernate.proxy.HibernateProxy": 
                case "org.springframework.context.annotation.ConfigurationClassEnhancer$EnhancedConfiguration": 
                case "org.mockito.cglib.proxy.Factory": {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static {
        Class clazz;
        void var3_5;
        Class[] classes;
        CLASS_SINGLE_SET = Collections.singleton(1).getClass();
        CACHE = new Cache();
        CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, char[].class, "chars");
        NAME_MAPPINGS = new IdentityHashMap<Class, String>();
        TYPE_MAPPINGS = new ConcurrentHashMap<String, Class>();
        NAME_MAPPINGS.put(Byte.TYPE, "B");
        NAME_MAPPINGS.put(Short.TYPE, "S");
        NAME_MAPPINGS.put(Integer.TYPE, "I");
        NAME_MAPPINGS.put(Long.TYPE, "J");
        NAME_MAPPINGS.put(Float.TYPE, "F");
        NAME_MAPPINGS.put(Double.TYPE, "D");
        NAME_MAPPINGS.put(Character.TYPE, "C");
        NAME_MAPPINGS.put(Boolean.TYPE, "Z");
        NAME_MAPPINGS.put(Object[].class, "[O");
        NAME_MAPPINGS.put(Object[][].class, "[[O");
        NAME_MAPPINGS.put(byte[].class, "[B");
        NAME_MAPPINGS.put(byte[][].class, "[[B");
        NAME_MAPPINGS.put(short[].class, "[S");
        NAME_MAPPINGS.put(short[][].class, "[[S");
        NAME_MAPPINGS.put(int[].class, "[I");
        NAME_MAPPINGS.put(int[][].class, "[[I");
        NAME_MAPPINGS.put(long[].class, "[J");
        NAME_MAPPINGS.put(long[][].class, "[[J");
        NAME_MAPPINGS.put(float[].class, "[F");
        NAME_MAPPINGS.put(float[][].class, "[[F");
        NAME_MAPPINGS.put(double[].class, "[D");
        NAME_MAPPINGS.put(double[][].class, "[[D");
        NAME_MAPPINGS.put(char[].class, "[C");
        NAME_MAPPINGS.put(char[][].class, "[[C");
        NAME_MAPPINGS.put(boolean[].class, "[Z");
        NAME_MAPPINGS.put(boolean[][].class, "[[Z");
        NAME_MAPPINGS.put(Byte[].class, "[Byte");
        NAME_MAPPINGS.put(Byte[][].class, "[[Byte");
        NAME_MAPPINGS.put(Short[].class, "[Short");
        NAME_MAPPINGS.put(Short[][].class, "[[Short");
        NAME_MAPPINGS.put(Integer[].class, "[Integer");
        NAME_MAPPINGS.put(Integer[][].class, "[[Integer");
        NAME_MAPPINGS.put(Long[].class, "[Long");
        NAME_MAPPINGS.put(Long[][].class, "[[Long");
        NAME_MAPPINGS.put(Float[].class, "[Float");
        NAME_MAPPINGS.put(Float[][].class, "[[Float");
        NAME_MAPPINGS.put(Double[].class, "[Double");
        NAME_MAPPINGS.put(Double[][].class, "[[Double");
        NAME_MAPPINGS.put(Character[].class, "[Character");
        NAME_MAPPINGS.put(Character[][].class, "[[Character");
        NAME_MAPPINGS.put(Boolean[].class, "[Boolean");
        NAME_MAPPINGS.put(Boolean[][].class, "[[Boolean");
        NAME_MAPPINGS.put(String[].class, "[String");
        NAME_MAPPINGS.put(String[][].class, "[[String");
        NAME_MAPPINGS.put(BigDecimal[].class, "[BigDecimal");
        NAME_MAPPINGS.put(BigDecimal[][].class, "[[BigDecimal");
        NAME_MAPPINGS.put(BigInteger[].class, "[BigInteger");
        NAME_MAPPINGS.put(BigInteger[][].class, "[[BigInteger");
        NAME_MAPPINGS.put(UUID[].class, "[UUID");
        NAME_MAPPINGS.put(UUID[][].class, "[[UUID");
        NAME_MAPPINGS.put(Object.class, "Object");
        NAME_MAPPINGS.put(HashMap.class, "M");
        TYPE_MAPPINGS.put("HashMap", HashMap.class);
        NAME_MAPPINGS.put(LinkedHashMap.class, "LM");
        TYPE_MAPPINGS.put("LinkedHashMap", LinkedHashMap.class);
        NAME_MAPPINGS.put(TreeMap.class, "TM");
        TYPE_MAPPINGS.put("TreeMap", TreeMap.class);
        NAME_MAPPINGS.put(ArrayList.class, "A");
        TYPE_MAPPINGS.put("ArrayList", ArrayList.class);
        NAME_MAPPINGS.put(LinkedList.class, "LA");
        TYPE_MAPPINGS.put("LinkedList", LinkedList.class);
        NAME_MAPPINGS.put(HashSet.class, "HashSet");
        NAME_MAPPINGS.put(TreeSet.class, "TreeSet");
        NAME_MAPPINGS.put(LinkedHashSet.class, "LinkedHashSet");
        NAME_MAPPINGS.put(ConcurrentHashMap.class, "ConcurrentHashMap");
        NAME_MAPPINGS.put(ConcurrentLinkedQueue.class, "ConcurrentLinkedQueue");
        NAME_MAPPINGS.put(JSONObject.class, "JSONObject");
        NAME_MAPPINGS.put(JSONArray.class, "JSONArray");
        NAME_MAPPINGS.put(Currency.class, "Currency");
        NAME_MAPPINGS.put(TimeUnit.class, "TimeUnit");
        Class[] classArray = classes = new Class[]{Object.class, Cloneable.class, AutoCloseable.class, Exception.class, RuntimeException.class, IllegalAccessError.class, IllegalAccessException.class, IllegalArgumentException.class, IllegalMonitorStateException.class, IllegalStateException.class, IllegalThreadStateException.class, IndexOutOfBoundsException.class, InstantiationError.class, InstantiationException.class, InternalError.class, InterruptedException.class, LinkageError.class, NegativeArraySizeException.class, NoClassDefFoundError.class, NoSuchFieldError.class, NoSuchFieldException.class, NoSuchMethodError.class, NoSuchMethodException.class, NullPointerException.class, NumberFormatException.class, OutOfMemoryError.class, SecurityException.class, StackOverflowError.class, StringIndexOutOfBoundsException.class, TypeNotPresentException.class, VerifyError.class, StackTraceElement.class, Hashtable.class, TreeMap.class, IdentityHashMap.class, WeakHashMap.class, HashSet.class, LinkedHashSet.class, TreeSet.class, LinkedList.class, TimeUnit.class, ConcurrentHashMap.class, AtomicInteger.class, AtomicLong.class, Collections.EMPTY_MAP.getClass(), Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Number.class, String.class, BigDecimal.class, BigInteger.class, BitSet.class, Calendar.class, Date.class, Locale.class, UUID.class, Currency.class, SimpleDateFormat.class, JSONObject.class, JSONArray.class, ConcurrentSkipListMap.class, ConcurrentSkipListSet.class};
        int n = classArray.length;
        boolean bl = false;
        while (var3_5 < n) {
            Class clazz2 = classArray[var3_5];
            TYPE_MAPPINGS.put(clazz2.getSimpleName(), clazz2);
            TYPE_MAPPINGS.put(clazz2.getName(), clazz2);
            NAME_MAPPINGS.put(clazz2, clazz2.getSimpleName());
            ++var3_5;
        }
        TYPE_MAPPINGS.put("JO10", JSONObject1O.class);
        TYPE_MAPPINGS.put("[O", Object[].class);
        TYPE_MAPPINGS.put("StackTraceElement", StackTraceElement.class);
        TYPE_MAPPINGS.put("[StackTraceElement", StackTraceElement[].class);
        String[] items = new String[]{"java.util.Collections$UnmodifiableMap", "java.util.Collections$UnmodifiableCollection"};
        for (String className : items) {
            Class clazz3 = TypeUtils.loadClass(className);
            TYPE_MAPPINGS.put(clazz3.getName(), clazz3);
        }
        Class objectClass = TypeUtils.loadClass("com.alibaba.fastjson.JSONObject");
        if (objectClass != null) {
            TYPE_MAPPINGS.putIfAbsent("JO1", objectClass);
            TYPE_MAPPINGS.putIfAbsent(objectClass.getName(), objectClass);
        }
        if ((clazz = TypeUtils.loadClass("com.alibaba.fastjson.JSONArray")) != null) {
            TYPE_MAPPINGS.putIfAbsent("JA1", clazz);
            TYPE_MAPPINGS.putIfAbsent(clazz.getName(), clazz);
        }
        NAME_MAPPINGS.put(new HashMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new LinkedHashMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new TreeMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new ConcurrentHashMap().keySet().getClass(), "Set");
        NAME_MAPPINGS.put(new ConcurrentSkipListMap().keySet().getClass(), "Set");
        TYPE_MAPPINGS.put("Set", HashSet.class);
        NAME_MAPPINGS.put(new HashMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new LinkedHashMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new TreeMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new ConcurrentHashMap().values().getClass(), "List");
        NAME_MAPPINGS.put(new ConcurrentSkipListMap().values().getClass(), "List");
        TYPE_MAPPINGS.put("List", ArrayList.class);
        for (Map.Entry entry : NAME_MAPPINGS.entrySet()) {
            TYPE_MAPPINGS.putIfAbsent((String)entry.getValue(), (Class)entry.getKey());
        }
    }

    static class Cache {
        volatile char[] chars;

        Cache() {
        }
    }
}

