/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring.data.redis;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class FastJsonRedisSerializer<T>
implements RedisSerializer<T> {
    private FastJsonConfig config = new FastJsonConfig();
    private final Class<T> type;

    public FastJsonRedisSerializer(Class<T> type) {
        this.type = type;
    }

    public FastJsonConfig getFastJsonConfig() {
        return this.config;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.config = fastJsonConfig;
    }

    public byte[] serialize(T t) throws SerializationException {
        if (t == null) {
            return new byte[0];
        }
        try {
            if (this.config.isJSONB()) {
                return JSONB.toBytes(t, this.config.getSymbolTable(), this.config.getWriterFilters(), this.config.getWriterFeatures());
            }
            return JSON.toJSONBytes(t, this.config.getDateFormat(), this.config.getWriterFilters(), this.config.getWriterFeatures());
        }
        catch (Exception ex) {
            throw new SerializationException("Could not serialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public T deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            if (this.config.isJSONB()) {
                return JSONB.parseObject(bytes, this.type, this.config.getSymbolTable(), this.config.getReaderFilters(), this.config.getReaderFeatures());
            }
            return JSON.parseObject(bytes, this.type, this.config.getDateFormat(), this.config.getReaderFilters(), this.config.getReaderFeatures());
        }
        catch (Exception ex) {
            throw new SerializationException("Could not deserialize: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

