/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.util;

import cn.langpy.kotime.config.DefaultConfig;
import cn.langpy.kotime.handler.InvokedHandler;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;

public class Context {
    private static Logger log = Logger.getLogger(Context.class.toString());
    private static DefaultConfig config;
    private static List<InvokedHandler> invokedHandlers;
    private static final String runKey;

    public static String getRunKey() {
        return runKey;
    }

    public static String getPid() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        return jvmName.split("@")[0];
    }

    public static String getIp() {
        String hostAddress = "localhost";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
            return hostAddress;
        }
        catch (UnknownHostException e) {
            log.severe("Can not get LocalHost:" + e.getMessage());
            return hostAddress;
        }
    }

    public static void setConfig(DefaultConfig koTimeConfig) {
        config = koTimeConfig;
    }

    public static DefaultConfig getConfig() {
        return config;
    }

    public static void addInvokedHandler(InvokedHandler invokedHandler) {
        invokedHandlers.add(invokedHandler);
    }

    public static List<InvokedHandler> getInvokedHandlers() {
        return invokedHandlers;
    }

    static {
        runKey = UUID.randomUUID().toString().replace("-", "");
        config = new DefaultConfig();
        config.setLogEnable(false);
        config.setEnable(true);
        config.setLogLanguage("chinese");
        invokedHandlers = new ArrayList<InvokedHandler>();
    }
}

