/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.config;

import cn.langpy.kotime.annotation.KoListener;
import cn.langpy.kotime.config.DefaultConfig;
import cn.langpy.kotime.handler.InvokedHandler;
import cn.langpy.kotime.handler.RunTimeHandler;
import cn.langpy.kotime.service.InvokedQueue;
import cn.langpy.kotime.util.Context;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@ComponentScan(value={"cn.langpy.kotime"})
@Configuration
public class LoadConfig {
    private static Logger log = Logger.getLogger(LoadConfig.class.toString());
    @Value(value="${server.servlet.context-path:}")
    private String serverContext;
    @Resource
    private DefaultConfig defaultConfig;
    @Resource
    private ApplicationContext applicationContext;

    @PostConstruct
    public void initConfig() {
        DefaultConfig config = new DefaultConfig();
        config.setLogEnable(this.defaultConfig.getLogEnable() == null ? false : this.defaultConfig.getLogEnable());
        config.setLogLanguage(this.defaultConfig.getLogLanguage() == null ? "chinese" : this.defaultConfig.getLogLanguage());
        config.setThreshold(this.defaultConfig.getThreshold() == null ? 800.0 : this.defaultConfig.getThreshold());
        config.setExceptionEnable(this.defaultConfig.getExceptionEnable() == null ? false : this.defaultConfig.getExceptionEnable());
        config.setEnable(this.defaultConfig.getEnable() == null ? true : this.defaultConfig.getEnable());
        config.setDataPrefix(this.defaultConfig.getDataPrefix() == null ? (StringUtils.hasText((String)this.serverContext) ? this.serverContext.substring(1) : "KOTIME") : this.defaultConfig.getDataPrefix());
        config.setLanguage(this.defaultConfig.getLanguage() == null ? "chinese" : this.defaultConfig.getLanguage());
        config.setThreadNum(this.defaultConfig.getThreadNum() == null ? 2 : this.defaultConfig.getThreadNum());
        config.setAuthEnable(this.defaultConfig.getAuthEnable() == null ? false : this.defaultConfig.getAuthEnable());
        config.setParamAnalyse(this.defaultConfig.getParamAnalyse() == null ? true : this.defaultConfig.getParamAnalyse());
        config.setDebug(this.defaultConfig.getDebug() == null ? false : this.defaultConfig.getDebug());
        Context.setConfig(config);
        log.info("kotime=>loading config");
        this.initMethodHandlers();
    }

    public void initMethodHandlers() {
        String[] names;
        for (String name : names = this.applicationContext.getBeanNamesForType(InvokedHandler.class)) {
            KoListener annotation;
            InvokedHandler bean = (InvokedHandler)this.applicationContext.getBean(name);
            if (null == bean || null == (annotation = bean.getClass().getAnnotation(KoListener.class))) continue;
            log.info("kotime=>loading InvokedHandler:" + bean.getClass().getSimpleName());
            Context.addInvokedHandler(bean);
        }
        for (int i = 0; i < Context.getConfig().getThreadNum(); ++i) {
            new Thread(() -> InvokedQueue.onInveked()).start();
        }
    }

    @Bean
    public AspectJExpressionPointcutAdvisor configurabledvisor() {
        log.info("kotime=>loading method listener");
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        String cutRange = this.defaultConfig.getPointcut();
        if (!StringUtils.hasText((String)cutRange)) {
            throw new RuntimeException("No 'ko-time.pointcut found,please set it.'");
        }
        cutRange = cutRange + " && !@annotation(cn.langpy.kotime.annotation.KoListener)";
        advisor.setExpression(cutRange);
        advisor.setAdvice((Advice)new RunTimeHandler());
        return advisor;
    }
}

