package cn.langpy.kotime.model;

import cn.langpy.kotime.grpc.api.RpcExceptionNode;

import java.util.Objects;

public class ExceptionNode {
    private String id;
    private String name;
    private String className;
    private String message;
    private Integer value;
    private String dataSource;

    public String getDataSource() {
        return dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExceptionNode that = (ExceptionNode) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return "ExceptionNode{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", className='" + className + '\'' +
                ", message='" + message + '\'' +
                ", value=" + value +
                '}';
    }

    public RpcExceptionNode toRpc() {
        return RpcExceptionNode.newBuilder()
                .setId(this.getId())
                .setName(this.getName())
                .setClassName(this.getClassName())
                .setMessage(this.getMessage())
                .setValue(this.getValue())
                .setDataSource(this.getDataSource())
                .build();
    }
}
