package cn.langpy.kotime.controller;

import cn.langpy.kotime.service.ClassService;
import cn.langpy.kotime.util.Context;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;


import java.io.*;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/**
 * zhangchang
 */
@Controller
@RequestMapping("/koTime")
public class KoTimeController {
    private static Logger log = Logger.getLogger(KoTimeController.class.toString());

    @PostMapping("/updateClass")
    @ResponseBody
    public Map updateClass(@RequestParam("classFile") MultipartFile classFile,String className,String runKey) {
        Map map = new HashMap();
        if (!Context.getRunKey().equals(runKey)) {
            map.put("state", 0);
            map.put("message", "连接错误");
            return map;
        }
        if (classFile==null || classFile.isEmpty()) {
            map.put("state", 0);
            map.put("message", "文件不能为空");
            return map;
        }
        if (!StringUtils.hasText(className)) {
            map.put("state", 0);
            map.put("message", "文类名不能为空");
            return map;
        }
        className = className.trim();
        File file = null;
        try {
            String originalFilename = classFile.getOriginalFilename();
            if (!originalFilename.endsWith(".class")) {
                map.put("state", 0);
                map.put("message", "仅支持.class文件");
                return map;
            }
            String[] filename = originalFilename.split("\\.");
            file = uploadFile(classFile.getBytes(),filename[0]);
        } catch (IOException e) {
            log.severe("Error class file!");
            map.put("state", 0);
            map.put("message", "无法解析文件");
            return map;
        }
        final ClassService classService = ClassService.getInstance();
        classService.updateClass(className,file.getAbsolutePath());
        file.deleteOnExit();
        map.put("state", 1);
        map.put("message", "更新成功");
        return map;
    }



    private static File uploadFile(byte[] file,String fileName) throws IOException {
        FileOutputStream out = null;
        try {
            File targetFile = File.createTempFile(fileName,  ".class", new File(System.getProperty("java.io.tmpdir")));
            out = new FileOutputStream(targetFile.getAbsolutePath());
            out.write(file);
            out.flush();
            return targetFile;
        } catch (Exception e) {
            log.severe("" + e);
        }finally {
            if(out !=null){
                out.flush();
                out.close();
            }
        }
        return null;
    }
}
