/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.util;

import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.InvokedInfo;
import cn.langpy.kotime.model.MethodNode;
import cn.langpy.kotime.service.InvokedQueue;
import cn.langpy.kotime.service.MethodNodeService;
import cn.langpy.kotime.util.RecordException;

public class KoUtil {
    public static void throwException(Exception e) {
        RecordException recordException = new RecordException(e);
        throw recordException;
    }

    public static void recordException(Exception e) {
        ExceptionNode exception = new ExceptionNode();
        exception.setName(e.getClass().getSimpleName());
        exception.setClassName(e.getClass().getName());
        exception.setMessage(e.getMessage() + "");
        exception.setId(exception.getClassName() + "." + exception.getName());
        MethodNode current = KoUtil.getCurrentMethodInfo();
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            if (!stackTraceElement.getClassName().equals(current.getClassName())) continue;
            exception.setValue(stackTraceElement.getLineNumber());
            InvokedInfo invokedInfo = new InvokedInfo();
            invokedInfo.setCurrent(current);
            invokedInfo.setException(exception);
            InvokedQueue.add(invokedInfo);
            InvokedQueue.wake();
            break;
        }
    }

    public static MethodNode getCurrentMethodInfo() {
        MethodNode methodNode = MethodNodeService.getParentMethodNode();
        return methodNode;
    }
}

