/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.service;

import cn.langpy.kotime.annotation.KoListener;
import cn.langpy.kotime.handler.InvokedHandler;
import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.MethodNode;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.util.BloomFilter;
import cn.langpy.kotime.util.Common;
import cn.langpy.kotime.util.Context;
import java.lang.reflect.Parameter;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.springframework.util.StringUtils;

@KoListener
public final class KoInvokedHandler
implements InvokedHandler {
    private static Logger log = Logger.getLogger(KoInvokedHandler.class.toString());
    @Resource
    private GraphService graphService;

    @Override
    public void onInvoked(MethodNode current, MethodNode parent, Parameter[] names, Object[] values) {
        if (current != null && current.getValue() == 0.0) {
            return;
        }
        this.graphService.addMethodNode(this.filter(parent));
        this.graphService.addMethodNode(this.filter(current));
        this.graphService.addMethodRelation(parent, current);
        if (Context.getConfig().getParamAnalyse().booleanValue()) {
            this.graphService.addParamAnalyse(current.getId(), names, values, current.getValue());
        }
        if (Context.getConfig().getLogEnable().booleanValue()) {
            Common.showLog(current);
        }
    }

    @Override
    public void onException(MethodNode current, MethodNode parent, ExceptionNode exception, Parameter[] names, Object[] values) {
        this.graphService.addMethodNode(current);
        this.graphService.addExceptionNode(exception);
        this.graphService.addExceptionRelation(current, exception);
    }

    private MethodNode filter(MethodNode currentNode) {
        if (BloomFilter.exists(currentNode.getId())) {
            if (!StringUtils.isEmpty((Object)currentNode.getRouteName())) {
                return currentNode;
            }
            return null;
        }
        BloomFilter.add(currentNode.getId());
        return currentNode;
    }
}

