/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.service;

import cn.langpy.kotime.grpc.api.DataServiceGrpc;
import cn.langpy.kotime.grpc.api.RpcExceptionRelation;
import cn.langpy.kotime.grpc.api.RpcMethodRelation;
import cn.langpy.kotime.grpc.api.RpcParamAnalyse;
import cn.langpy.kotime.handler.AuthCredential;
import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.MethodNode;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.util.Common;
import cn.langpy.kotime.util.Context;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.lang.reflect.Parameter;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DefaultGraphService
implements GraphService {
    private static Logger log = Logger.getLogger(DefaultGraphService.class.toString());
    @Value(value="${ko-time.data-host:localhost}")
    private String host;
    @Value(value="${ko-time.data-port:9906}")
    private Integer port;
    @Value(value="${ko-time.data-prefix:}")
    private String dataPrefix;
    @Value(value="${server.servlet.context-path:}")
    private String serverContext;
    @Value(value="${server.port:8080}")
    private Integer serverPort;
    @Value(value="${ko-time.data-token:}")
    private String token;
    private ManagedChannel channel;
    private DataServiceGrpc.DataServiceFutureStub futureStub;
    private AuthCredential authCredential;

    public synchronized boolean connectServer() {
        this.authCredential = new AuthCredential(this.createClientName(), this.token.trim());
        try {
            this.channel = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(this.host, this.port).usePlaintext()).build();
            log.info("kotime=>KoTime Server was connected. host=" + this.host + " port=" + this.port);
            this.futureStub = DataServiceGrpc.newFutureStub(this.channel);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("No server found.");
            return false;
        }
        return true;
    }

    private String getProjectName() {
        if (!StringUtils.hasText((String)this.dataPrefix)) {
            if (StringUtils.hasText((String)this.serverContext)) {
                this.dataPrefix = this.serverContext.substring(1);
            } else {
                log.severe("kotime=>Undefined ko-time.data-prefix,please define it so that KoTime Server can know the datasource!");
            }
        }
        return this.dataPrefix;
    }

    private String createClientName() {
        return Base64.getEncoder().encodeToString((this.getProjectName() + "-" + Context.getIp() + "-" + this.serverPort + "-" + (StringUtils.hasText((String)this.serverContext) ? this.serverContext : "/") + "-" + Context.getRunKey()).getBytes(Charset.defaultCharset()));
    }

    public synchronized boolean checkServer() {
        boolean connectState = true;
        if (this.channel == null || this.channel.isTerminated()) {
            connectState = this.connectServer();
        }
        return connectState;
    }

    @Override
    public void addMethodNode(MethodNode methodNode) {
        if (methodNode == null) {
            return;
        }
        boolean b = this.checkServer();
        if (!b) {
            return;
        }
        methodNode.setDataSource(this.getProjectName());
        ((DataServiceGrpc.DataServiceFutureStub)((DataServiceGrpc.DataServiceFutureStub)this.futureStub.withCallCredentials(this.authCredential)).withDeadlineAfter(2L, TimeUnit.SECONDS)).addMethodNode(methodNode.toRpc());
    }

    @Override
    public void addParamAnalyse(String methodId, Parameter[] names, Object[] values, double v) {
        if (!StringUtils.hasText((String)methodId)) {
            return;
        }
        boolean b = this.checkServer();
        if (!b) {
            return;
        }
        String paramsKey = Common.getPramsStr(names, values);
        RpcParamAnalyse paramAnalyse = RpcParamAnalyse.newBuilder().setDataSource(this.getProjectName()).setMethodId(methodId).setParamsKey(paramsKey).setTimeValue(v).build();
        ((DataServiceGrpc.DataServiceFutureStub)this.futureStub.withCallCredentials(this.authCredential)).addParamAnalyse(paramAnalyse);
    }

    @Override
    public void addExceptionNode(ExceptionNode exceptionNode) {
        if (exceptionNode == null) {
            return;
        }
        boolean b = this.checkServer();
        if (!b) {
            return;
        }
        exceptionNode.setDataSource(this.getProjectName());
        ((DataServiceGrpc.DataServiceFutureStub)this.futureStub.withCallCredentials(this.authCredential)).addExceptionNode(exceptionNode.toRpc());
    }

    @Override
    public void addMethodRelation(MethodNode sourceMethodNode, MethodNode targetMethodNode) {
        if (sourceMethodNode == null || targetMethodNode == null) {
            return;
        }
        boolean b = this.checkServer();
        if (!b) {
            return;
        }
        sourceMethodNode.setDataSource(this.getProjectName());
        targetMethodNode.setDataSource(this.getProjectName());
        RpcMethodRelation methodRelation = RpcMethodRelation.newBuilder().setDataSource(this.getProjectName()).setSource(sourceMethodNode.toRpc()).setTarget(targetMethodNode.toRpc()).build();
        ((DataServiceGrpc.DataServiceFutureStub)this.futureStub.withCallCredentials(this.authCredential)).addMethodRelation(methodRelation);
    }

    @Override
    public void addExceptionRelation(MethodNode sourceMethodNode, ExceptionNode exceptionNode) {
        if (sourceMethodNode == null || exceptionNode == null) {
            return;
        }
        boolean b = this.checkServer();
        if (!b) {
            return;
        }
        sourceMethodNode.setDataSource(this.getProjectName());
        exceptionNode.setDataSource(this.getProjectName());
        RpcExceptionRelation exceptionRelation = RpcExceptionRelation.newBuilder().setDataSource(this.getProjectName()).setSource(sourceMethodNode.toRpc()).setTarget(exceptionNode.toRpc()).build();
        ((DataServiceGrpc.DataServiceFutureStub)this.futureStub.withCallCredentials(this.authCredential)).addExceptionRelation(exceptionRelation);
    }
}

