/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.controller;

import cn.langpy.kotime.service.ClassService;
import cn.langpy.kotime.util.Context;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/koTime"})
public class KoTimeController {
    private static Logger log = Logger.getLogger(KoTimeController.class.toString());

    @PostMapping(value={"/updateClass"})
    @ResponseBody
    public Map updateClass(@RequestParam(value="classFile") MultipartFile classFile, String className, String runKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!Context.getRunKey().equals(runKey)) {
            map.put("state", 0);
            map.put("message", "\u8fde\u63a5\u9519\u8bef");
            return map;
        }
        if (classFile == null || classFile.isEmpty()) {
            map.put("state", 0);
            map.put("message", "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            return map;
        }
        if (!StringUtils.hasText((String)className)) {
            map.put("state", 0);
            map.put("message", "\u6587\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return map;
        }
        className = className.trim();
        File file = null;
        try {
            String originalFilename = classFile.getOriginalFilename();
            if (!originalFilename.endsWith(".class")) {
                map.put("state", 0);
                map.put("message", "\u4ec5\u652f\u6301.class\u6587\u4ef6");
                return map;
            }
            String[] filename = originalFilename.split("\\.");
            file = KoTimeController.uploadFile(classFile.getBytes(), filename[0]);
        }
        catch (IOException e) {
            log.severe("Error class file!");
            map.put("state", 0);
            map.put("message", "\u65e0\u6cd5\u89e3\u6790\u6587\u4ef6");
            return map;
        }
        ClassService classService = ClassService.getInstance();
        classService.updateClass(className, file.getAbsolutePath());
        file.deleteOnExit();
        map.put("state", 1);
        map.put("message", "\u66f4\u65b0\u6210\u529f");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File uploadFile(byte[] file, String fileName) throws IOException {
        OutputStream out = null;
        try {
            File targetFile = File.createTempFile(fileName, ".class", new File(System.getProperty("java.io.tmpdir")));
            out = new FileOutputStream(targetFile.getAbsolutePath());
            ((FileOutputStream)out).write(file);
            out.flush();
            File file2 = targetFile;
            return file2;
        }
        catch (Exception e) {
            log.severe("" + e);
        }
        finally {
            if (out != null) {
                out.flush();
                ((FileOutputStream)out).close();
            }
        }
        return null;
    }
}

