/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.core;

import cn.langpy.core.ListFrame;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapFrame<K, V>
extends HashMap<K, V> {
    public MapFrame<K, MapFrame<Object, ListFrame>> groupBy(String column) {
        MapFrame mapFrames = new MapFrame();
        Set ks = this.keySet();
        for (Object k : ks) {
            MapFrame<Object, Cloneable> mapFrame;
            Cloneable vFrame;
            Object v = this.get(k);
            if (v instanceof ListFrame) {
                vFrame = (ListFrame)v;
                mapFrame = ((ListFrame)vFrame).groupBy(column);
                mapFrames.put(k, mapFrame);
                continue;
            }
            if (!(v instanceof MapFrame)) continue;
            vFrame = (MapFrame)v;
            mapFrame = ((MapFrame)vFrame).groupBy(column);
            mapFrames.put(k, mapFrame);
        }
        return mapFrames;
    }

    public <T> MapFrame<K, T> count() {
        MapFrame mapInt = new MapFrame();
        Set ks = this.keySet();
        for (Object k : ks) {
            Cloneable vFrame;
            Object v = this.get(k);
            if (v instanceof ListFrame) {
                vFrame = (ListFrame)v;
                Integer size = ((ArrayList)vFrame).size();
                mapInt.put(k, size);
                continue;
            }
            if (!(v instanceof MapFrame)) continue;
            vFrame = (MapFrame)v;
            MapFrame<K, T> count = ((MapFrame)vFrame).count();
            mapInt.put(k, count);
        }
        return mapInt;
    }

    public <T> MapFrame<K, T> sum(String sumColumn) {
        MapFrame map = new MapFrame();
        Set ks = this.keySet();
        for (Object k : ks) {
            Serializable sum;
            Cloneable vFrame;
            Object v = this.get(k);
            if (v instanceof ListFrame) {
                vFrame = (ListFrame)v;
                sum = ((ListFrame)vFrame).get(sumColumn).sum();
                map.put(k, (Double)sum);
                continue;
            }
            if (!(v instanceof MapFrame)) continue;
            vFrame = (MapFrame)v;
            sum = ((MapFrame)vFrame).sum(sumColumn);
            map.put(k, (Double)sum);
        }
        return map;
    }

    public <T> MapFrame<K, T> max(String maxColumn) {
        MapFrame map = new MapFrame();
        Set ks = this.keySet();
        for (Object k : ks) {
            Object max;
            Cloneable vFrame;
            Object v = this.get(k);
            if (v instanceof ListFrame) {
                vFrame = (ListFrame)v;
                max = ((ListFrame)vFrame).get(maxColumn).max();
                map.put(k, max);
                continue;
            }
            if (!(v instanceof MapFrame)) continue;
            vFrame = (MapFrame)v;
            max = ((MapFrame)vFrame).max(maxColumn);
            map.put(k, max);
        }
        return map;
    }

    public <T> MapFrame<K, T> min(String minColumn) {
        MapFrame map = new MapFrame();
        Set ks = this.keySet();
        for (Object k : ks) {
            Object min;
            Cloneable vFrame;
            Object v = this.get(k);
            if (v instanceof ListFrame) {
                vFrame = (ListFrame)v;
                min = ((ListFrame)vFrame).get(minColumn).min();
                map.put(k, min);
                continue;
            }
            if (!(v instanceof MapFrame)) continue;
            vFrame = (MapFrame)v;
            min = ((MapFrame)vFrame).min(minColumn);
            map.put(k, min);
        }
        return map;
    }

    public <T> MapFrame<K, T> concat(String concatColumn) {
        MapFrame map = new MapFrame();
        Set ks = this.keySet();
        for (Object k : ks) {
            Cloneable vFrame;
            Object v = this.get(k);
            if (v instanceof ListFrame) {
                vFrame = (ListFrame)v;
                map.put(k, ((ListFrame)vFrame).get(concatColumn));
                continue;
            }
            if (!(v instanceof MapFrame)) continue;
            vFrame = (MapFrame)v;
            MapFrame<K, T> concat = ((MapFrame)vFrame).concat(concatColumn);
            map.put(k, concat);
        }
        return map;
    }

    public <T> MapFrame<K, T> avg(String avgColumn) {
        MapFrame map = new MapFrame();
        Set ks = this.keySet();
        for (Object k : ks) {
            Serializable avg;
            Cloneable vFrame;
            Object v = this.get(k);
            if (v instanceof ListFrame) {
                vFrame = (ListFrame)v;
                avg = ((ListFrame)vFrame).get(avgColumn).avg();
                map.put(k, (Double)avg);
                continue;
            }
            if (!(v instanceof MapFrame)) continue;
            vFrame = (MapFrame)v;
            avg = ((MapFrame)vFrame).avg(avgColumn);
            map.put(k, (Double)avg);
        }
        return map;
    }

    public Map<K, Double> toHashMap() {
        return this;
    }
}

