/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.util;

import cn.langpy.constant.DataBaseType;
import cn.langpy.core.ListFrame;
import cn.langpy.model.DataBaseConfig;
import cn.langpy.model.TableInfo;
import com.alibaba.druid.pool.DruidDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DataBaseUtil {
    static Map<String, DataSource> dataSourceMap = null;

    public static ListFrame<Map<String, Object>> readSql(String sql, DataBaseConfig dataBaseConfig) {
        DataSource dataSource = DataBaseUtil.getDataSource(dataBaseConfig);
        return DataBaseUtil.readSql(sql, dataSource);
    }

    public static DataSource getDataSource(DataBaseConfig dataBaseConfig) {
        String key = dataBaseConfig.getHost() + dataBaseConfig.getPort() + dataBaseConfig.getDatabase() + dataBaseConfig.getUserName();
        if (dataSourceMap.containsKey(key)) {
            return dataSourceMap.get(key);
        }
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUsername(dataBaseConfig.getUserName());
        dataSource.setPassword(dataBaseConfig.getPassword());
        if (dataBaseConfig.getDatabaseType() == DataBaseType.MYSQL) {
            dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
            dataSource.setUrl(String.format("jdbc:mysql://%s:%s/%s", dataBaseConfig.getHost(), dataBaseConfig.getPort(), dataBaseConfig.getDatabase()));
        } else if (dataBaseConfig.getDatabaseType() == DataBaseType.ORACLE) {
            dataSource.setDriverClassName("oracle.jdbc.driver.OracleDriver");
            dataSource.setUrl(String.format("jdbc:oracle:thin:@%s:%s:%s", dataBaseConfig.getHost(), dataBaseConfig.getPort(), dataBaseConfig.getDatabase()));
        } else {
            throw new RuntimeException("please define DataBaseType!");
        }
        dataSourceMap.put(key, dataSource);
        return dataSource;
    }

    public static ListFrame<Map<String, Object>> readSql(String sql, DataSource dataSource) {
        ListFrame<Map<String, Object>> listFrame = new ListFrame<Map<String, Object>>();
        try (Connection connection = dataSource.getConnection();){
            PreparedStatement statement = connection.prepareStatement(sql);
            ResultSetMetaData metaData = statement.getMetaData();
            ResultSet resultSet = statement.executeQuery(sql);
            List<TableInfo> columns = DataBaseUtil.getColumns(metaData);
            while (resultSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (TableInfo column : columns) {
                    map.put(column.getName(), DataBaseUtil.getColumnValue(resultSet, column));
                }
                listFrame.add(map);
            }
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return listFrame;
    }

    private static Object getColumnValue(ResultSet resultSet, TableInfo column) throws SQLException {
        if ("VARCHAR".equals(column.getDataType()) || "TEXT".equals(column.getDataType())) {
            return resultSet.getString(column.getName());
        }
        if ("DATETIME".equals(column.getDataType())) {
            return resultSet.getTimestamp(column.getName());
        }
        if ("INT".equals(column.getDataType())) {
            return resultSet.getInt(column.getName());
        }
        return resultSet.getObject(column.getName());
    }

    private static List<TableInfo> getColumns(ResultSetMetaData metaData) throws SQLException {
        ArrayList<TableInfo> colnames = new ArrayList<TableInfo>();
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            String colname = metaData.getColumnName(i + 1);
            String colType = metaData.getColumnTypeName(i + 1);
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName(colname);
            tableInfo.setDataType(colType);
            colnames.add(tableInfo);
        }
        return colnames;
    }

    static {
        dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    }
}

