/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.disroute.core;

import cn.langpy.disroute.annotation.Route;
import cn.langpy.disroute.config.SpringContext;
import cn.langpy.disroute.core.RouteInterface;
import cn.langpy.disroute.core.RoutePool;
import cn.langpy.disroute.exception.InvalidContextException;
import cn.langpy.disroute.exception.InvalidRoutePathException;
import cn.langpy.disroute.exception.NotInitRouteException;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.stereotype.Component;

public class RouteContext {
    public static Logger log = Logger.getLogger(RouteContext.class.toString());
    static ConcurrentHashMap<String, Object> instanceMap = new ConcurrentHashMap();
    static ConcurrentHashMap<String, Method> methodMap = new ConcurrentHashMap();
    static ConcurrentHashMap<String, Boolean> methodAsyncMap = new ConcurrentHashMap();
    static ConcurrentHashMap<String, Boolean> interfaceMap = new ConcurrentHashMap();
    static ConcurrentHashMap<String, String> keyMap = new ConcurrentHashMap();
    static volatile boolean initFlag = false;

    protected static boolean isInit() {
        return initFlag;
    }

    protected static void init() {
        RouteContext.init("");
    }

    public static void close() {
        if (RoutePool.isFree()) {
            instanceMap.clear();
            methodMap.clear();
            keyMap.clear();
            RoutePool.closePool();
        }
        initFlag = false;
    }

    protected static synchronized void init(String packagePath) {
        if (RouteContext.isInit()) {
            return;
        }
        Reflections reflections = null;
        reflections = packagePath != null && packagePath.length() > 1 ? new Reflections(packagePath, new Scanner[0]) : new Reflections(new Object[0]);
        Set services = reflections.getTypesAnnotatedWith(Route.class);
        for (Class service : services) {
            Route contextRoute = service.getAnnotation(Route.class);
            if (null == contextRoute || null == contextRoute.value()) continue;
            String context = contextRoute.value();
            if (null == context || context.length() < 1) {
                context = "/".concat(service.getSimpleName());
            } else if (!context.startsWith("/")) {
                context = "/".concat(context);
            }
            Object instance = RouteContext.initInstance(service);
            if (instance instanceof RouteInterface) {
                String[] pathSplit = context.split("/");
                if (pathSplit.length != 3) {
                    throw new InvalidRoutePathException("error to create " + service.getSimpleName() + ".java with @Route ,please refer to @Route(\"/key/value\")");
                }
                String simpleName = RouteContext.getSuperClass(service).getSimpleName();
                context = "/".concat(simpleName).concat(context);
                Method onRoute = null;
                try {
                    onRoute = service.getMethod("onRoute", Object.class);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                methodMap.put(context, onRoute);
                methodAsyncMap.put(context, contextRoute.async());
                keyMap.put("/".concat(simpleName), pathSplit[1]);
                interfaceMap.put("/".concat(simpleName), true);
            } else {
                Method[] methods;
                for (Method method : methods = service.getDeclaredMethods()) {
                    Route routePath = method.getDeclaredAnnotation(Route.class);
                    if (null == routePath || null == routePath.value()) continue;
                    String path = routePath.value();
                    String[] pathSplit = path.split("/");
                    if (pathSplit.length != 3) {
                        throw new InvalidRoutePathException("error @Route,please refer to @Route(\"/key/value\")");
                    }
                    String key = "";
                    key = pathSplit[1];
                    methodMap.put(context + path, method);
                    keyMap.put(context, key);
                    interfaceMap.put(context, false);
                    methodAsyncMap.put(context + path, routePath.async());
                }
            }
            if (instanceMap.containsKey(context)) continue;
            instanceMap.put(context, RouteContext.initInstance(service));
            log.info("register @Route for " + service.getSimpleName());
        }
        initFlag = true;
    }

    private static Class<?> getSuperClass(Class<?> service) {
        Class<?>[] interfaces = service.getInterfaces();
        if (interfaces.length > 0) {
            return interfaces[0];
        }
        throw new InvalidRoutePathException("error to create " + service.getSimpleName() + ".java with @Route ,please implements an interface from RouteInterface!");
    }

    private static Object initInstance(Class<?> service) {
        Object instance = null;
        try {
            Component component;
            instance = RouteContext.isSpring() ? ((component = service.getAnnotation(Component.class)) == null ? (Object)service.newInstance() : SpringContext.applicationContext.getBean(service)) : (Object)service.newInstance();
        }
        catch (InstantiationException e) {
            log.severe("can not register @Route for " + service.getSimpleName());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            log.severe("can not register @Route for " + service.getSimpleName());
            e.printStackTrace();
        }
        return instance;
    }

    private static boolean isSpring() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.springframework.stereotype.Component");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private static String getKey(String context) {
        String key = keyMap.get("/".concat(context));
        if (key == null) {
            throw new InvalidContextException();
        }
        return key;
    }

    private static Object getValue(String key, Object param) {
        Object keyValue = null;
        if (param instanceof String || param instanceof Integer || param instanceof Double || param instanceof Float) {
            keyValue = param;
        } else if (param instanceof JSONObject) {
            JSONObject map = (JSONObject)param;
            keyValue = map.get((Object)key);
        } else if (param instanceof Map) {
            Map map = (Map)param;
            keyValue = map.get(key);
        } else {
            Field[] fields = param.getClass().getDeclaredFields();
            Optional<Field> keyFieldOption = Arrays.stream(fields).filter(name -> name.getName().equals(key)).findFirst();
            keyFieldOption.orElseThrow(() -> new InvalidRoutePathException());
            Field keyField = keyFieldOption.get();
            keyField.setAccessible(true);
            try {
                keyValue = keyField.get(param);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return keyValue;
    }

    private static Method getMethod(String context, String key, Object keyValue) {
        Method method = methodMap.get("/".concat(context).concat("/").concat(key).concat("/").concat(keyValue + ""));
        if (method == null && (method = methodMap.get("/".concat(context).concat("/").concat(key).concat("/*"))) == null) {
            throw new RuntimeException(String.format("can not find a method with @Route(\"/%s/%s\"),please create it!", key, keyValue));
        }
        return method;
    }

    private static <T> T getResult(Object instance, Method method, Object param) {
        Object result = null;
        Object resultObject = null;
        try {
            resultObject = method.invoke(instance, param);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (resultObject != null) {
            result = resultObject;
        }
        return (T)result;
    }

    public static <T> T dispatch(String context, Object param) {
        if (!RouteContext.isInit()) {
            throw new NotInitRouteException();
        }
        if (context.equals("context")) {
            if (((ConcurrentHashMap.CollectionView)((Object)instanceMap.keySet())).size() == 1) {
                Iterator<Object> iterator = instanceMap.values().iterator();
                if (iterator.hasNext()) {
                    Object value = iterator.next();
                    context = value.getClass().getSimpleName();
                }
            } else {
                throw new RuntimeException(String.format("please define a context before dispatch() !", new Object[0]));
            }
        }
        String key = RouteContext.getKey(context);
        Object keyValue = RouteContext.getValue(key, param);
        Method method = RouteContext.getMethod(context, key, keyValue);
        Object instance = RouteContext.getInstance(context, key, keyValue);
        Route routePath = method.getAnnotation(Route.class);
        if (!RouteContext.isAsync(context, key, keyValue)) {
            T result = RouteContext.getResult(instance, method, param);
            if (routePath != null && routePath.nextContext().length() > 1) {
                return RouteContext.dispatch(routePath.nextContext(), result);
            }
            return result;
        }
        ThreadPoolExecutor threadExecutor = RoutePool.getPool();
        Object finalInstance = instance;
        threadExecutor.execute(() -> RouteContext.getResult(finalInstance, method, param));
        return null;
    }

    private static boolean isAsync(String context, String key, Object value) {
        Boolean b = methodAsyncMap.get("/".concat(context).concat("/").concat(key).concat("/").concat(value + ""));
        if (b == null) {
            b = methodAsyncMap.getOrDefault("/".concat(context).concat("/").concat(key).concat("/*"), false);
        }
        return b;
    }

    private static Object getInstance(String context, String key, Object value) {
        Object instance = null;
        if (interfaceMap.get("/".concat(context)).booleanValue()) {
            instance = instanceMap.get("/".concat(context).concat("/").concat(key).concat("/").concat(value + ""));
            if (instance == null) {
                instance = instanceMap.get("/".concat(context).concat("/").concat(key).concat("/*"));
            }
        } else {
            instance = instanceMap.get("/".concat(context));
        }
        return instance;
    }

    public static <T> T dispatchAsync(String context, Object param) {
        if (!RouteContext.isInit()) {
            throw new NotInitRouteException();
        }
        String key = RouteContext.getKey(context);
        Object keyValue = RouteContext.getValue(key, param);
        Method method = RouteContext.getMethod(context, key, keyValue);
        Object instance = RouteContext.getInstance(context, key, keyValue);
        ThreadPoolExecutor threadExecutor = RoutePool.getPool();
        Object finalInstance = instance;
        threadExecutor.execute(() -> RouteContext.getResult(finalInstance, method, param));
        return null;
    }
}

