package cn.langpy.disroute.core;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.util.logging.Logger;

/**
 * Chang Zhang
 */
@Component
public class ContextInit implements ApplicationRunner {
    @Value("${disroute.scan:com}")
    private String disrouteScan;
    public static Logger log = Logger.getLogger(ContextInit.class.toString());

    @Override
    public void run(ApplicationArguments args) throws Exception {
        log.info("init disroute---start");
        if (disrouteScan.equals("com")) {
            Route.init();
            log.warning("can not find 'disroute.scan' in application.yml, you can define it such as 'disroute.scan=com.xxx' if you want to start faster!");
        } else {
            Route.init(disrouteScan);
        }
        log.info("init disroute---end");
    }

}
