/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.disroute.core;

import cn.langpy.disroute.annotation.Route;
import cn.langpy.disroute.config.SpringContext;
import cn.langpy.disroute.core.RoutePool;
import cn.langpy.disroute.exception.InvalidContextException;
import cn.langpy.disroute.exception.InvalidRoutePathException;
import cn.langpy.disroute.exception.NotInitRouteException;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.stereotype.Component;

public class RouteContext {
    public static Logger log = Logger.getLogger(RouteContext.class.toString());
    static ConcurrentHashMap<String, Object> instanceMap = new ConcurrentHashMap();
    static ConcurrentHashMap<String, Method> methodMap = new ConcurrentHashMap();
    static ConcurrentHashMap<String, String> keyMap = new ConcurrentHashMap();
    static volatile boolean initFlag = false;

    public static boolean isInit() {
        return initFlag;
    }

    public static void init() {
        RouteContext.init("");
    }

    public static void close() {
        if (RoutePool.isFree()) {
            instanceMap.clear();
            methodMap.clear();
            keyMap.clear();
            RoutePool.closePool();
        }
        initFlag = false;
    }

    public static void init(String packagePath) {
        if (RouteContext.isInit()) {
            return;
        }
        Reflections reflections = null;
        reflections = packagePath != null && packagePath.length() > 1 ? new Reflections(packagePath, new Scanner[0]) : new Reflections(new Object[0]);
        Set sevices = reflections.getTypesAnnotatedWith(Route.class);
        for (Class sevice : sevices) {
            Method[] methods;
            Route contextRoute = sevice.getAnnotation(Route.class);
            if (null == contextRoute || null == contextRoute.value()) continue;
            String context = contextRoute.value();
            if (null == context || context.length() < 1) {
                context = "/".concat(sevice.getSimpleName());
            } else if (!context.startsWith("/")) {
                context = "/".concat(context);
            }
            for (Method method : methods = sevice.getDeclaredMethods()) {
                Route routePath = method.getDeclaredAnnotation(Route.class);
                if (null == routePath || null == routePath.value()) continue;
                String path = routePath.value();
                String[] pathSplit = path.split("/");
                if (pathSplit.length != 3) {
                    throw new InvalidRoutePathException("error @Route,please refer to @Route(\"/key/value\"");
                }
                String key = "";
                key = pathSplit[1];
                try {
                    String instanceKey = context.concat("/").concat(key);
                    if (!instanceMap.containsKey(instanceKey)) {
                        if (RouteContext.isSpring()) {
                            Component component = sevice.getAnnotation(Component.class);
                            if (component == null) {
                                instanceMap.put(instanceKey, sevice.newInstance());
                            } else {
                                instanceMap.put(instanceKey, SpringContext.applicationContext.getBean(sevice));
                            }
                        } else {
                            instanceMap.put(instanceKey, sevice.newInstance());
                        }
                        log.info("register @Route for " + sevice.getSimpleName());
                    }
                    methodMap.put(context + path, method);
                    keyMap.put(context, key);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        initFlag = true;
    }

    public static boolean isSpring() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.springframework.stereotype.Component");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static String getKey(String context) {
        String key = keyMap.get("/".concat(context));
        if (key == null) {
            throw new InvalidContextException();
        }
        return key;
    }

    private static Object getValue(String key, Object param) {
        Object keyValue = null;
        if (param instanceof String || param instanceof Integer || param instanceof Double || param instanceof Float) {
            keyValue = param;
        } else if (param instanceof JSONObject) {
            JSONObject map = (JSONObject)param;
            keyValue = map.get((Object)key);
        } else if (param instanceof Map) {
            Map map = (Map)param;
            keyValue = map.get(key);
        } else {
            Field[] fields = param.getClass().getDeclaredFields();
            Optional<Field> keyFieldOption = Arrays.stream(fields).filter(name -> name.getName().equals(key)).findFirst();
            keyFieldOption.orElseThrow(() -> new InvalidRoutePathException());
            Field keyField = keyFieldOption.get();
            keyField.setAccessible(true);
            try {
                keyValue = keyField.get(param);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return keyValue;
    }

    private static Method getMethod(String context, String key, Object keyValue) {
        Method method = methodMap.get("/".concat(context).concat("/").concat(key).concat("/").concat(keyValue + ""));
        if (method == null && (method = methodMap.get("/".concat(context).concat("/").concat(key).concat("/*"))) == null) {
            throw new RuntimeException(String.format("can not find a method with @Route(\"/%s/%s\"),please create it!", key, keyValue));
        }
        return method;
    }

    private static <T> T getResult(Method method, String context, String key, Object param) {
        Object result = null;
        Object resultObject = null;
        try {
            resultObject = method.invoke(instanceMap.get("/".concat(context).concat("/").concat(key)), param);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (resultObject != null) {
            result = resultObject;
        }
        return (T)result;
    }

    public static <T> T dispatch(String context, Object param) {
        Object keyValue;
        String key;
        Method method;
        Route routePath;
        if (!RouteContext.isInit()) {
            throw new NotInitRouteException();
        }
        if (context.equals("context")) {
            if (((ConcurrentHashMap.CollectionView)((Object)instanceMap.keySet())).size() == 1) {
                Iterator<Object> iterator = instanceMap.values().iterator();
                if (iterator.hasNext()) {
                    Object value = iterator.next();
                    context = value.getClass().getSimpleName();
                }
            } else {
                throw new RuntimeException(String.format("please define a context before dispatch() !", new Object[0]));
            }
        }
        if (!(routePath = (method = RouteContext.getMethod(context, key = RouteContext.getKey(context), keyValue = RouteContext.getValue(key, param))).getAnnotation(Route.class)).async()) {
            T result = RouteContext.getResult(method, context, key, param);
            if (routePath.nextContext().length() > 1) {
                return RouteContext.dispatch(routePath.nextContext(), result);
            }
            return result;
        }
        ThreadPoolExecutor threadExecutor = RoutePool.getPool();
        String asyncContext = context;
        threadExecutor.execute(() -> RouteContext.getResult(method, asyncContext, key, param));
        return null;
    }

    public static <T> T dispatchAsync(String context, Object param) {
        if (!RouteContext.isInit()) {
            throw new NotInitRouteException();
        }
        String key = RouteContext.getKey(context);
        Object keyValue = RouteContext.getValue(key, param);
        Method method = RouteContext.getMethod(context, key, keyValue);
        ThreadPoolExecutor threadExecutor = RoutePool.getPool();
        threadExecutor.execute(() -> RouteContext.getResult(method, context, key, param));
        return null;
    }
}

